/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.index;

import eu.dnetlib.scholexplorer.api.index.ElasticSearchProperties;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

public class ElasticSearchClientFactory
implements PooledObjectFactory<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> {
    private final ElasticSearchProperties elasticSearchProperties;

    public ElasticSearchClientFactory(ElasticSearchProperties elasticSearchProperties) {
        this.elasticSearchProperties = elasticSearchProperties;
    }

    public PooledObject<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> makeObject() throws Exception {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().connectedTo(this.elasticSearchProperties.getClusterNodes().split(",")).withConnectTimeout(this.elasticSearchProperties.getConnectionTimeout()).withSocketTimeout(this.elasticSearchProperties.getSocketTimeout()).build();
        RestHighLevelClient cc = RestClients.create((ClientConfiguration)clientConfiguration).rest();
        return new DefaultPooledObject((Object)new ImmutablePair((Object)cc, (Object)new ElasticsearchRestTemplate(cc)));
    }

    public void destroyObject(PooledObject<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> pooledObject) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)((Pair)pooledObject.getObject()).getLeft();
        if (client != null && client.ping(RequestOptions.DEFAULT)) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> pooledObject) {
        RestHighLevelClient client = (RestHighLevelClient)((Pair)pooledObject.getObject()).getLeft();
        try {
            return client.ping(RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> pooledObject) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)((Pair)pooledObject.getObject()).getLeft();
        boolean response = client.ping(RequestOptions.DEFAULT);
    }

    public void passivateObject(PooledObject<Pair<RestHighLevelClient, ElasticsearchRestTemplate>> pooledObject) throws Exception {
    }
}

