/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholexplorer.api.controller;

import eu.dnetlib.dhp.schema.sx.api.model.v2.LinkProviderType;
import eu.dnetlib.scholexplorer.api.ScholixException;
import eu.dnetlib.scholexplorer.api.index.ScholixIndexManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2"})
@Tag(name="LinkProvider : Operation related to the Link Provider")
public class LinkProviderV2 {
    @Autowired
    ScholixIndexManager manager;

    @Operation(summary="Get all Link Providers", description="Return a list of link provider and relative number of relations")
    @GetMapping(value={"/LinkProvider"})
    public List<LinkProviderType> getLinkProviders(@Parameter(in=ParameterIn.QUERY, description="Filter the link provider name") @RequestParam(required=false) String name) throws ScholixException {
        ArrayList<LinkProviderType> result = new ArrayList<LinkProviderType>();
        this.manager.getLinkProviders().forEach((k, v) -> {
            if (name == null || k.toLowerCase().contains(name.toLowerCase())) {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            } else {
                result.add(new LinkProviderType().name(k).totalRelationships(Integer.valueOf(v.intValue())));
            }
        });
        return result;
    }
}

