/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.excel;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVFileWriter {
    private static final String NEW_LINE_SEPARATOR = "\n";
    private Object[] file_header;
    private ArrayList<ArrayList<String>> projects = new ArrayList();

    public void setHeader(String[] header) {
        this.file_header = header;
    }

    public void addProject(ArrayList<String> project) {
        this.projects.add(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String csv_file_path) {
        BufferedWriter writer = null;
        CSVPrinter csvFilePrinter = null;
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withRecordSeparator(NEW_LINE_SEPARATOR);
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv_file_path), "UTF-8"));
            csvFilePrinter = new CSVPrinter((Appendable)writer, csvFileFormat);
            csvFilePrinter.printRecord(this.file_header);
            for (ArrayList<String> project : this.projects) {
                csvFilePrinter.printRecord(project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.flush();
                writer.close();
                csvFilePrinter.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

