/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.czechProject;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class CzechProjectsPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(CzechProjectsPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String token = (String)interfaceDescriptor.getParams().get("token");
        int fromYear = NumberUtils.toInt((String)((String)interfaceDescriptor.getParams().get("fromYear")), (int)0);
        int toYear = NumberUtils.toInt((String)((String)interfaceDescriptor.getParams().get("toYear")), (int)0);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new CollectorServiceException("baseUrl is empty");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new CollectorServiceException("Authorization token is empty");
        }
        if (fromYear < 1900 || toYear < 1900 || toYear < fromYear) {
            throw new CollectorServiceException("Invalid year range");
        }
        return () -> IntStream.rangeClosed(fromYear, toYear).mapToObj(year -> this.fetchProjects(baseUrl, token, year)).flatMap(Collection::stream).iterator();
    }

    /*
     * Exception decompiling
     */
    private List<String> fetchProjects(String url, String token, int year) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<String> toXmlList(InputStream is) throws IOException {
        String content = IOUtils.toString((InputStream)is);
        JSONObject obj = new JSONObject(content);
        JSONArray jsonList = obj.getJSONArray("data");
        return StreamSupport.stream(jsonList.spliterator(), false).map(r -> this.patchXmlFields(r)).map(r -> XML.toString((Object)r, (String)"record")).collect(Collectors.toList());
    }

    private Object patchXmlFields(Object r) {
        if (r instanceof JSONArray) {
            JSONArray res = new JSONArray();
            for (Object o : (JSONArray)r) {
                res.put(this.patchXmlFields(o));
            }
            return res;
        }
        if (r instanceof JSONObject) {
            JSONObject res = new JSONObject();
            for (String k : ((JSONObject)r).keySet()) {
                String nk = k.matches("[0-9]+") ? "_" + k : k;
                Object nv = this.patchXmlFields(((JSONObject)r).get(k));
                res.put(nk, nv);
            }
            return res;
        }
        if (r instanceof String) {
            return StringEscapeUtils.escapeXml10((String)((String)r));
        }
        return r;
    }
}

