/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasets;

import com.google.common.collect.Maps;
import eu.dnetlib.data.collector.plugins.datasets.DatasetsIterator;
import eu.dnetlib.data.collector.plugins.datasets.QueryField;
import eu.dnetlib.data.collector.plugins.datasets.RequestField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetsByProjectIterator
implements Iterable<String>,
Iterator<String> {
    private static final String SPLIT_REGEX = ";";
    public static String PROJECT_ID_KEY = "id";
    public static String PROJECT_NAME_KEY = "name";
    public static String PROJECT_CORDA_ID_KEY = "corda_id";
    private Iterator<String> currentIterator;
    private BufferedReader csvReader;
    private Map<String, String> currentProject;
    private static final Log log = LogFactory.getLog(DatasetsByProjectIterator.class);

    public DatasetsByProjectIterator(InputStreamReader csvInputStream) throws IOException {
        this.csvReader = new BufferedReader(csvInputStream);
        this.currentProject = this.extractNextLine();
    }

    @Override
    public boolean hasNext() {
        if (this.currentProject == null) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        this.currentProject = this.extractNextLine();
        while (this.currentProject != null) {
            this.currentIterator = this.getNextIterator();
            if (this.currentIterator.hasNext()) {
                return true;
            }
            this.currentProject = this.extractNextLine();
        }
        return false;
    }

    @Override
    public String next() {
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<String> iterator() {
        if (this.currentProject != null) {
            this.currentIterator = this.getNextIterator();
            return this;
        }
        return null;
    }

    private Iterator<String> getNextIterator() {
        QueryField q = new QueryField();
        RequestField r = new RequestField();
        r.setQuery(q);
        q.getTerm().put("ft-techkeyword", this.currentProject.get(PROJECT_ID_KEY));
        return new DatasetsIterator(r, this.currentProject.get(PROJECT_CORDA_ID_KEY), null).iterator();
    }

    private Map<String, String> extractNextLine() {
        String line;
        try {
            line = this.csvReader.readLine();
        }
        catch (IOException e) {
            return null;
        }
        if (line == null) {
            return null;
        }
        log.debug((Object)("splitting line: " + line));
        String[] values = line.split(SPLIT_REGEX);
        if (values == null || values.length != 4) {
            log.error((Object)"Error on splitting line, the length must be 4");
            return null;
        }
        int id = Integer.parseInt(values[0]);
        String project_name = values[2];
        String cordaId = values[3];
        HashMap splittedMap = Maps.newHashMap();
        splittedMap.put(PROJECT_CORDA_ID_KEY, cordaId);
        splittedMap.put(PROJECT_ID_KEY, "project" + id);
        splittedMap.put(PROJECT_NAME_KEY, project_name);
        log.debug((Object)String.format("found project %s with id Corda: %s and id for API: %s", project_name, cordaId, "project" + id));
        return splittedMap;
    }
}

