/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.doiresolver;

import eu.dnetlib.data.collector.plugins.HttpConnector;
import eu.dnetlib.data.collector.plugins.doiresolver.DOIResolver;
import eu.dnetlib.data.collector.plugins.utils.JsonUtils;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CrossrefResolver
implements DOIResolver {
    private static final Log log = LogFactory.getLog(CrossrefResolver.class);
    private String baseURL = "https://api.crossref.org/works/";
    public static Pattern CROSSREF_DOI_REGEXP = Pattern.compile("^10\\.\\d{4,9}/[-._;()/:A-Z0-9]+$", 2);
    @Autowired
    private HttpConnector httpConnector;

    @Override
    public String resolve(String doi) {
        if (this.isValid(doi)) {
            try {
                InputStream is = this.httpConnector.getInputSourceAsStream(this.getBaseURL() + doi);
                return this.asXml(IOUtils.toString((InputStream)is));
            }
            catch (CollectorServiceException | IOException e) {
                log.error((Object)("Cannot resolve doi " + doi + " Exception: " + e));
                return null;
            }
        }
        log.debug((Object)("Input does not look like a valid DOI " + doi));
        return null;
    }

    protected boolean isValid(String doi) {
        return CROSSREF_DOI_REGEXP.matcher(doi).matches();
    }

    protected String asXml(String record) {
        return new JsonUtils().convertToXML(record);
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public HttpConnector getHttpConnector() {
        return this.httpConnector;
    }

    public void setHttpConnector(HttpConnector httpConnector) {
        this.httpConnector = httpConnector;
    }
}

