/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.doiresolver;

import eu.dnetlib.data.collector.plugins.doiresolver.CrossrefResolver;
import eu.dnetlib.data.collector.plugins.filesystem.FileSystemIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DOIResolverIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(DOIResolverIterator.class);
    protected static final String STARTER = "FIRE";
    protected static final String TERMINATOR = "ARNOLD";
    protected static final String BAD_TERMINATOR = "BAD";
    protected static final String UNRESOLVED = "UNRESOLVED";
    protected static long TIMEOUT = 5L;
    protected static TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private String baseDir;
    private String fromDate;
    private ArrayBlockingQueue<String> queue;
    private CrossrefResolver crossrefResolver;

    public DOIResolverIterator(String baseDir, CrossrefResolver crossrefResolver, String fromDate) {
        this.baseDir = baseDir;
        this.fromDate = fromDate;
        this.queue = new ArrayBlockingQueue(100);
        this.crossrefResolver = crossrefResolver;
        this.init();
    }

    private void init() {
        log.info((Object)"Init");
        new Thread(() -> {
            block15: {
                try {
                    FileSystemIterator fsi = new FileSystemIterator(this.baseDir, "csv", this.fromDate);
                    if (!this.queue.offer(STARTER)) break block15;
                    while (fsi.hasNext()) {
                        String filePath = fsi.next();
                        try {
                            Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));
                            Throwable throwable = null;
                            try {
                                stream.forEach(doi -> {
                                    try {
                                        String resolved = this.resolve((String)doi);
                                        if (!resolved.equals(UNRESOLVED)) {
                                            this.queue.offer(resolved, TIMEOUT, TIMEOUT_UNIT);
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        log.error((Object)("DOI processing aborted, cannot offer resolved doi: " + doi + " . Did the consumer die?"));
                                        log.error((Object)e);
                                        this.queue.offer(BAD_TERMINATOR);
                                    }
                                });
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stream == null) continue;
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                stream.close();
                            }
                        }
                        catch (IOException e) {
                            log.error((Object)"DOI processing aborted");
                            log.error((Object)e);
                            this.queue.offer(BAD_TERMINATOR);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"DOI processing aborted");
                    log.error((Object)e);
                    this.queue.offer(BAD_TERMINATOR);
                }
            }
            this.queue.offer(TERMINATOR);
            log.info((Object)"Finished processing DOI list");
        }).start();
    }

    private String resolve(String doi) {
        log.debug((Object)("Resolving " + doi));
        log.debug((Object)"Crossref...");
        String record = this.crossrefResolver.resolve(this.cleanDOI(doi));
        if (StringUtils.isNotBlank((String)record)) {
            return record;
        }
        log.debug((Object)"Resolver returned blank item");
        return UNRESOLVED;
    }

    protected String cleanDOI(String doi) {
        return doi.replace("http://dx.doi.org/", "").replace("https://dx.doi.org/", "").replace("https://doi.org/", "").replace("http://doi.org/", "");
    }

    @Override
    public boolean hasNext() {
        return this.doHasNext();
    }

    private boolean doHasNext() {
        String element = this.queue.peek();
        while (element == null) {
            try {
                log.debug((Object)"Sleeping while waiting for something in the queue");
                Thread.sleep(1000L);
                element = this.queue.peek();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)("Found in queue element: " + element));
        switch (element) {
            case "ARNOLD": 
            case "BAD": {
                return false;
            }
            case "FIRE": 
            case "UNRESOLVED": {
                this.queue.poll();
                return this.doHasNext();
            }
        }
        return true;
    }

    @Override
    public String next() {
        return this.queue.poll();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public CrossrefResolver getCrossrefResolver() {
        return this.crossrefResolver;
    }

    public void setCrossrefResolver(CrossrefResolver crossrefResolver) {
        this.crossrefResolver = crossrefResolver;
    }
}

