package eu.dnetlib.enabling.datasources.common;

import java.util.HashSet;
import java.util.Set;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SearchApisEntry implements Comparable<SearchApisEntry> {

	private String id;
	private String compliance;
	private String protocol;
	private boolean active;
	private String repoId = "unknown";
	private String repoName = "unknown";
	private String alternativeName = "unknown";
	private String repoOrganization = "unknown";
	private String repoCountry = "-";
	private String repoPrefix = "";

	private String aggrDate = "";
	private int aggrTotal = 0;
	private String aggrBackend = "";

	private String collDate = "";
	private int collTotal = 0;
	private String collBackend = "";
	private String primaryProvideGateway = "";
	private Set<String> affiliatedProvideGateways = new HashSet<>();

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getCompliance() {
		return compliance;
	}

	public void setCompliance(final String compliance) {
		this.compliance = compliance;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(final boolean active) {
		this.active = active;
	}

	public String getRepoId() {
		return repoId;
	}

	public void setRepoId(final String repoId) {
		this.repoId = repoId;
	}

	public String getRepoName() {
		return repoName;
	}

	public void setRepoName(final String repoName) {
		this.repoName = repoName;
	}

	public String getRepoCountry() {
		return repoCountry;
	}

	public void setRepoCountry(final String repoCountry) {
		this.repoCountry = repoCountry;
	}

	public String getRepoPrefix() {
		return repoPrefix;
	}

	public void setRepoPrefix(final String repoPrefix) {
		this.repoPrefix = repoPrefix;
	}

	@Override
	public int compareTo(final SearchApisEntry e) {
		return compliance.compareTo(e.getCompliance());
	}

	public String getAggrDate() {
		return aggrDate;
	}

	public void setAggrDate(final String aggrDate) {
		this.aggrDate = aggrDate;
	}

	public int getAggrTotal() {
		return aggrTotal;
	}

	public void setAggrTotal(final int aggrTotal) {
		this.aggrTotal = aggrTotal;
	}

	public String getAggrBackend() {
		return aggrBackend;
	}

	public void setAggrBackend(final String aggrBackend) {
		this.aggrBackend = aggrBackend;
	}

	public String getCollDate() {
		return collDate;
	}

	public void setCollDate(final String collDate) {
		this.collDate = collDate;
	}

	public int getCollTotal() {
		return collTotal;
	}

	public void setCollTotal(final int collTotal) {
		this.collTotal = collTotal;
	}

	public String getCollBackend() {
		return collBackend;
	}

	public void setCollBackend(final String collBackend) {
		this.collBackend = collBackend;
	}

	public String getProtocol() {
		return protocol;
	}

	public void setProtocol(final String protocol) {
		this.protocol = protocol;
	}

	public String getAlternativeName() {
		return alternativeName;
	}

	public void setAlternativeName(final String alternativeName) {
		this.alternativeName = alternativeName;
	}

	public String getRepoOrganization() {
		return repoOrganization;
	}

	public void setRepoOrganization(final String repoOrganization) {
		this.repoOrganization = repoOrganization;
	}

	public String getPrimaryProvideGateway() {
		return primaryProvideGateway;
	}

	public void setPrimaryProvideGateway(final String primaryProvideGateway) {
		this.primaryProvideGateway = primaryProvideGateway;
	}

	public Set<String> getAffiliatedProvideGateways() {
		return affiliatedProvideGateways;
	}

	public void setAffiliatedProvideGateways(final Set<String> affiliatedProvideGateways) {
		this.affiliatedProvideGateways = affiliatedProvideGateways;
	}

}
