/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop.hbase;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.hadoop.hbase.StoreHBaseRecordsJobNode;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractHBaseJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(StoreHBaseRecordsJobNode.class);
    private final String INPUT_HBASE_TABLE_PARAM = "hbaseTable";
    private final String INPUT_EPR_PARAM = "input_epr";
    private final String INPUT_CLUSTER_PARAM = "cluster";
    private final String XSLT_PARAM = "xslt";
    private final String OUTPUT_HBASE_TABLE_PARAM = "table";
    private final String OUTPUT_CLUSTER_PARAM = "cluster";
    private final String SIMULATION_PARAM = "simulation";
    @Autowired
    protected UniqueServiceLocator serviceLocator;
    protected String inputEprParam;
    protected String hbaseTableProperty;
    protected String cluster;
    protected String mapping;
    protected boolean simulation = false;
    protected ProgressProvider progressProvider;
    protected ProcessCountingResultSetFactory processCountingResultSetFactory;

    protected abstract HadoopBlackboardActions getAction();

    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        log.info((Object)("Invoking blackboard method: " + this.getAction().toString()));
        job.setAction(this.getAction().toString());
        job.getParameters().put("input_epr", DnetXsltFunctions.encodeBase64((String)this.prepareEpr(token)));
        job.getParameters().put("xslt", DnetXsltFunctions.encodeBase64((String)this.readXslt(this.getMapping())));
        job.getParameters().put("table", this.tableName(token));
        job.getParameters().put("cluster", this.cluster(token));
        job.getParameters().put("simulation", String.valueOf(this.isSimulation()));
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, final NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                String count = responseParams.get("count");
                log.info((Object)String.format("%s %s objects to HBase table %s, cluster %s", AbstractHBaseJobNode.this.getAction().toString(), count, AbstractHBaseJobNode.this.tableName(token), AbstractHBaseJobNode.this.cluster(token)));
                env.setAttribute("mainlog:" + AbstractHBaseJobNode.this.getName() + ":count", count);
            }
        };
    }

    protected String tableName(NodeToken token) {
        if (token.getEnv().hasAttribute("hbaseTable")) {
            String table = token.getEnv().getAttribute("hbaseTable");
            log.debug((Object)("found override value in wfEnv for 'hbaseTable' param: " + table));
            return table;
        }
        return this.getPropertyFetcher().getProperty(this.getHbaseTableProperty());
    }

    protected String cluster(NodeToken token) {
        if (token.getEnv().hasAttribute("cluster")) {
            String cluster = token.getEnv().getAttribute("cluster");
            log.debug((Object)("found override value in wfEnv for 'cluster' param: " + cluster));
            return cluster;
        }
        return this.getCluster();
    }

    private String prepareEpr(NodeToken token) throws ResultSetException {
        String epr = token.getEnv().getAttribute(this.inputEprParam);
        ResultsetProgressProvider resultsetProgressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        this.setProgressProvider((ProgressProvider)resultsetProgressProvider);
        return resultsetProgressProvider.getEpr().toString();
    }

    private String readXslt(String profileId) throws IOException, MSROException, ISLookUpException {
        if (StringUtils.isBlank((String)profileId)) {
            throw new MSROException("missing profile id");
        }
        log.info((Object)("loading mapping from profile id: " + profileId));
        String xquery = String.format("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']", profileId);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getHbaseTableProperty() {
        return this.hbaseTableProperty;
    }

    public void setHbaseTableProperty(String hbaseTableProperty) {
        this.hbaseTableProperty = hbaseTableProperty;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }
}

