package eu.dnetlib.msro.workflows.dedup;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class DedupCheckConfigurationJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(DedupCheckConfigurationJobNode.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String dedupConfigSequenceParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String dcoJson = token.getEnv().getAttribute(getDedupConfigSequenceParam());

		final DedupConfigurationOrchestration dco = DedupConfigurationOrchestration.fromJSON(dcoJson);

		if (!existActionSetProfile(dco)) throw new MSROException("missing action set profile: " + dco.getActionSetId());

		log.info("found action set profile: " + dco.getActionSetId());

		return Arc.DEFAULT_ARC;
	}

	private boolean existActionSetProfile(final DedupConfigurationOrchestration dco) throws ISLookUpException {
		final String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ACTION_SET/@id='%s'] return 1";
		log.info("looking for action set profile, id: " + dco.getActionSetId());
		final List<String> actionSets = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(String.format(xquery, dco.getActionSetId()));
		return !actionSets.isEmpty();
	}

	public String getDedupConfigSequenceParam() {
		return dedupConfigSequenceParam;
	}

	public void setDedupConfigSequenceParam(final String dedupConfigSequenceParam) {
		this.dedupConfigSequenceParam = dedupConfigSequenceParam;
	}

}
