package eu.dnetlib.msro.workflows.dedup;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ResetCountersJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(ResetCountersJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String attributesCSV;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		if (StringUtils.isNotBlank(getAttributesCSV())) {

			log.info("got wf attributes CSV: " + getAttributesCSV());

			final Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();
			final List<String> wfAttrs = splitter.splitToList(getAttributesCSV());

			for (final String attr : wfAttrs) {
				resetWorkflowParam(token, attr);
			}

		} else {
			log.info("attribute list is empty, nothing to do here.");
		}

		return Arc.DEFAULT_ARC;
	}

	private void resetWorkflowParam(final NodeToken token, final String attribute) {
		final String count = token.getFullEnv().getAttribute(attribute);
		if (StringUtils.isNotBlank(count)) {
			log.info(String.format("found loop counter '%s', value '%s'", attribute, count));
			token.getFullEnv().setAttribute(attribute, 0);

			log.info(String.format("set '%s', to 0", attribute));
		} else {
			log.info("loop counter was not found in workflow env, nothing to do here.");
		}
	}

	public String getAttributesCSV() {
		return attributesCSV;
	}

	public void setAttributesCSV(final String attributesCSV) {
		this.attributesCSV = attributesCSV;
	}

}
