package eu.dnetlib.msro.workflows.hadoop;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class CreateHdfsDirectoryJobNode extends BlackboardJobNode {

	private String cluster;

	private boolean force = false;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(HadoopService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {

		job.setAction(HadoopBlackboardActions.CREATE_HDFS_DIR.toString());
		job.getParameters().put("cluster", getCluster());
		job.getParameters().put("force", String.valueOf(isForce()));

		// The "path" parameter is set by the following call
		job.getParameters().putAll(parseJsonParameters(token));
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public boolean isForce() {
		return force;
	}

	public void setForce(boolean force) {
		this.force = force;
	}
}
