package eu.dnetlib.msro.workflows.hadoop;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class DeleteHdfsPathJobNode extends BlackboardJobNode {

	private String cluster;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(HadoopService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {

		job.setAction(HadoopBlackboardActions.DELETE_HDFS_PATH.toString());
		job.getParameters().put("cluster", getCluster());

		// The "path" parameter is set by the following call
		job.getParameters().putAll(parseJsonParameters(token));
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

}
