/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.dedup;

import com.google.common.collect.Lists;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import eu.dnetlib.msro.workflows.hadoop.utils.Similarity;
import eu.dnetlib.msro.workflows.hadoop.utils.SimilarityMeshBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class DedupDbDAO {
    private static final Log log = LogFactory.getLog(DedupDbDAO.class);
    @Value(value="${dnet.dedup.db.name}")
    private String dbName;
    @Resource
    private UniqueServiceLocator serviceLocator;

    public boolean commit(SimilarityGroup group) throws Exception {
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        log.info((Object)"adding similarities");
        this.updateGroupSql(dbService, group);
        log.info((Object)"adding dissimilarities");
        this.dissimilaritiesSql(dbService, group);
        return true;
    }

    private void updateGroupSql(DatabaseService dbService, SimilarityGroup group) throws Exception {
        log.info((Object)"cleanup similarities");
        for (String id : group.getGroup()) {
            this.safeUpdateSql(dbService, this.dbName, String.format("DELETE FROM similarity_groups WHERE objidentifier = '%s'; ", id));
        }
        log.info((Object)"cleanup empty groups");
        this.safeUpdateSql(dbService, this.dbName, "DELETE FROM groups WHERE id NOT IN (SELECT groupid FROM similarity_groups)");
        log.info((Object)"reverting dissimilarities");
        for (Similarity s : this.mesh(group)) {
            this.safeUpdateSql(dbService, this.dbName, String.format("DELETE FROM dissimilarities WHERE actionsetid = '%s' AND id1 = '%s' AND id2 = '%s'; ", group.getActionSet(), s.getPair().getKey(), s.getPair().getValue()));
        }
        log.info((Object)("adding new group, size: " + group.getGroup().size()));
        String type = group.getEntityType().getType();
        this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO groups(id, entitytype, date, actionsetid) VALUES('%s', '%s', '%s', '%s'); ", group.getId(), type, group.getDate(), group.getActionSet()));
        for (String id : group.getGroup()) {
            if (!dbService.contains(this.dbName, "entities", "id", id)) {
                this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", id, type));
            }
            this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO similarity_groups(groupid, objidentifier) VALUES('%s', '%s'); ", group.getId(), id));
        }
    }

    private List<Similarity> mesh(SimilarityGroup group) {
        return SimilarityMeshBuilder.build(TypeProtos.Type.valueOf((String)group.getEntityType().getType()), Lists.newArrayList(group.getGroup()), false);
    }

    private void dissimilaritiesSql(DatabaseService dbService, SimilarityGroup group) throws Exception {
        String type = group.getEntityType().getType();
        for (Map.Entry<String, Set<String>> e : group.getDissimilar().entrySet()) {
            if (!dbService.contains(this.dbName, "entities", "id", e.getKey())) {
                this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", e.getKey(), type));
            }
            for (String id : e.getValue()) {
                if (dbService.contains(this.dbName, "entities", "id", id)) continue;
                this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO entities(id, entitytype) VALUES('%s', '%s'); ", id, type));
            }
        }
        log.info((Object)"store dissimilarities");
        for (Map.Entry<String, Set<String>> e : group.getDissimilar().entrySet()) {
            for (String id : e.getValue()) {
                this.safeUpdateSql(dbService, this.dbName, String.format("INSERT INTO dissimilarities(id1, id2, actionsetid) VALUES('%s', '%s', '%s'); ", e.getKey(), id, group.getActionSet()));
            }
        }
    }

    private void safeUpdateSql(DatabaseService dbService, String dbName, String sql) throws Exception {
        try {
            log.info((Object)sql);
            dbService.updateSQL(dbName, sql);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.debug((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw e;
        }
    }
}

