package eu.dnetlib.openaire.directindex.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.common.collect.Maps;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class IndexClientMap {

    private static final Log log = LogFactory.getLog(IndexClientMap.class);

    @Value(value = "${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;

    @Value(value = "${openaire.api.directindex.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;

    @Resource
    private UniqueServiceLocator serviceLocator;

    @Autowired
    private IndexDSRetriever indexDSRetriever;

    private Map<IndexDsInfo, CloudIndexClient> clients = Maps.newHashMap();

    public Map<IndexDsInfo, CloudIndexClient> getClients() throws DirecIndexApiException {
        try {
            final List<IndexDsInfo> idxList = indexDSRetriever.calculateCurrentIndexDsInfo();

            if (idxList == null || idxList.isEmpty()) {
                throw new DirecIndexApiException("cannot create index: no public Search Service found");
            }
            if (idxList.size() > 1) {
                log.warn("found more than 1 public search service");
            }

            for(IndexDsInfo i : idxList) {
                if (!clients.containsKey(i)) {
                    clients.put(i, CloudIndexClientFactory.newIndexClient(i.getIndexBaseUrl(), i.getColl(), false));
                }
            }
            return clients;

        } catch (IOException | ISLookUpException | CloudIndexClientException e) {
            throw new DirecIndexApiException(e);
        }
    }

}