/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class RecentResultsQueue
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(RecentResultsQueue.class);
    private DB db;
    private String collection;

    public void init() {
        if (!this.db.collectionExists(this.collection)) {
            log.info((Object)String.format("creating collection %s", this.collection));
            this.db.createCollection(this.collection, (DBObject)new BasicDBObject());
        }
    }

    @Override
    public Iterator<String> iterator() {
        final DBCursor cursor = this.db.getCollection(this.collection).find();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public String next() {
                DBObject obj = cursor.next();
                return obj != null && obj.containsField("record") ? obj.get("record").toString() : "";
            }

            @Override
            public void remove() {
                throw new RuntimeException("NOT IMPLEMENTED");
            }
        };
    }

    public synchronized void add(String oaf) throws Exception {
        String id = new SAXReader().read((Reader)new StringReader(oaf)).valueOf("//*[local-name() = 'objIdentifier']");
        log.info((Object)("Saving record " + id + " in db: " + this.db.getName() + ", coll: " + this.collection));
        DBCollection coll = this.db.getCollection(this.collection);
        DBObject obj = BasicDBObjectBuilder.start().append("id", (Object)id).append("record", (Object)oaf).append("date", (Object)DateUtils.now()).get();
        coll.update((DBObject)new BasicDBObject("id", (Object)id), obj, true, false);
    }

    public void remove(List<String> list) {
        DBCollection coll = this.db.getCollection(this.collection);
        for (String id : list) {
            coll.remove((DBObject)new BasicDBObject("id", (Object)id));
        }
    }

    public void remove(String ... ids) {
        DBCollection coll = this.db.getCollection(this.collection);
        for (String id : ids) {
            coll.remove((DBObject)new BasicDBObject("id", (Object)id));
        }
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }

    public String getCollection() {
        return this.collection;
    }

    @Required
    public void setCollection(String collection) {
        this.collection = collection;
    }
}

