/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.common.rmi.DNetRestDocumentation;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.RecentResultsQueue;
import eu.dnetlib.openaire.directindex.objects.ResultEntry;
import eu.dnetlib.openaire.directindex.utils.OafToIndexRecordFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@DNetRestDocumentation
public class OpenaireResultSubmitter {
    private static final Log log = LogFactory.getLog(OpenaireResultSubmitter.class);
    @Value(value="oaf.schema.location")
    private String oafSchemaLocation;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private RecentResultsQueue recentResultsQueue;
    @Resource(name="openaireplusApisVelocityEngine")
    private VelocityEngine velocityEngine;
    @Value(value="${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaire.api.directindex.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;
    @Value(value="${openaire.api.directindex.autocommit.active}")
    private boolean autocommitactive;
    @Value(value="${openaire.api.directindex.autocommit.frequency}")
    private long commitfrquency = 60L;
    private static long COMMIT_FREQUENCY_MINVALUE = 5L;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture task = null;
    private AtomicBoolean commitSuccessful = new AtomicBoolean(false);

    public OpenaireResultSubmitter() {
        this.updateSchedule();
    }

    private void updateSchedule() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.task = this.executor.scheduleAtFixedRate(this.doCommit(), 0L, this.getCommitfrquency(), TimeUnit.SECONDS);
    }

    private Runnable doCommit() {
        return () -> {
            if (this.isAutocommitactive()) {
                try {
                    for (Map.Entry<IndexDsInfo, CloudIndexClient> e : this.getClients().entrySet()) {
                        IndexDsInfo i = e.getKey();
                        CloudIndexClient client = e.getValue();
                        Throwable throwable = null;
                        try {
                            log.info((Object)("performing commit on " + i.getColl()));
                            client.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (client == null) continue;
                            if (throwable != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            client.close();
                        }
                    }
                    this.commitSuccessful.set(true);
                }
                catch (CloudIndexClientException | DirecIndexApiException | IOException e) {
                    this.commitSuccessful.set(false);
                    throw new RuntimeException((Throwable)e);
                }
            }
        };
    }

    @RequestMapping(value={"/api/admin/autocommit/active"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean getAutocommit() throws DirecIndexApiException {
        return this.isAutocommitactive();
    }

    @RequestMapping(value={"/api/admin/autocommit/active"}, method={RequestMethod.POST})
    @ResponseBody
    public Boolean setAutocommit(@RequestParam(value="active", required=true) Boolean active) throws DirecIndexApiException {
        this.setAutocommitactive(active);
        log.info((Object)String.format("automatic commit, active '%s', frequency '%s'", this.isAutocommitactive(), this.getCommitfrquency()));
        return this.isAutocommitactive();
    }

    @RequestMapping(value={"/api/admin/autocommit/frequency"}, method={RequestMethod.GET})
    @ResponseBody
    public long getAutocommitFrequency() throws DirecIndexApiException {
        return this.getCommitfrquency();
    }

    @RequestMapping(value={"/api/admin/autocommit/frequency"}, method={RequestMethod.POST})
    @ResponseBody
    public long setAutocommitFrequency(@RequestParam(value="frequency", required=true) Integer frequency) throws DirecIndexApiException {
        this.setCommitfrquency(frequency.intValue());
        log.info((Object)String.format("automatic commit, active '%s', frequency '%s'", this.isAutocommitactive(), this.getCommitfrquency()));
        return this.getCommitfrquency();
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/feedJson", "/api/results/feedJson"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObjectJson(@RequestParam(value="json", required=true) String json, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        ResultEntry pub = (ResultEntry)new Gson().fromJson(json, ResultEntry.class);
        return this.feedObject(pub, commit);
    }

    @RequestMapping(value={"/api/results/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedResult(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.feed(pub, commit);
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public String feedObject(@RequestBody ResultEntry pub, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.feed(pub, commit);
    }

    @RequestMapping(value={"/api/result/{openaireId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOpenaireId(@PathVariable(value="openaireId") String openaireId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws DirecIndexApiException {
        return this.deleteResult(openaireId, commit);
    }

    @RequestMapping(value={"/api/results"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean deleteResultWithOriginalId(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntry.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId, commit);
    }

    @Deprecated
    @RequestMapping(value={"/api/publications/deleteObject", "/api/results/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean deleteResultPost(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId, @RequestParam(value="commit", required=false, defaultValue="true") boolean commit) throws Exception {
        String openaireId = ResultEntry.calculateOpenaireId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
        return this.deleteResult(openaireId, commit);
    }

    @Deprecated
    private String feed(ResultEntry pub, boolean commit) throws DirecIndexApiException {
        return this.feed(pub);
    }

    private String feed(ResultEntry pub) throws DirecIndexApiException {
        try {
            String oafRecord = pub.asOafRecord(this.velocityEngine, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class), this.oafSchemaLocation);
            for (Map.Entry<IndexDsInfo, CloudIndexClient> e : this.getClients().entrySet()) {
                IndexDsInfo idx = e.getKey();
                CloudIndexClient client = e.getValue();
                Throwable throwable = null;
                try {
                    client.feed(oafRecord, idx.getIndexDsId(), (UnaryFunction)this.oafToIndexRecordFactory.newTransformer(idx.getFormat()), false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            this.recentResultsQueue.add(oafRecord);
            String string = pub.getOpenaireId();
            return string;
        }
        catch (Throwable e) {
            log.error((Object)"Error saving record", e);
            log.debug((Object)pub.toString());
            throw new DirecIndexApiException("Error adding publication: " + e.getMessage(), e);
        }
        finally {
            if (!this.commitSuccessful.get()) {
                log.info((Object)"commit thread died, rescheduling ...");
                this.updateSchedule();
            }
        }
    }

    private boolean deleteResult(String openaireId, boolean commit) throws DirecIndexApiException {
        try {
            for (Map.Entry<IndexDsInfo, CloudIndexClient> e : this.getClients().entrySet()) {
                IndexDsInfo idx = e.getKey();
                CloudIndexClient client = e.getValue();
                Throwable throwable = null;
                try {
                    client.remove(openaireId, false);
                    log.info((Object)("Deleted result with id: " + openaireId + " from: " + idx.getIndexBaseUrl()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            this.recentResultsQueue.remove(openaireId);
            return true;
        }
        catch (Throwable e) {
            throw new DirecIndexApiException("Error deleting publication: " + e.getMessage(), e);
        }
    }

    private Map<IndexDsInfo, CloudIndexClient> getClients() throws DirecIndexApiException {
        try {
            List<IndexDsInfo> idxList = this.calculateCurrentIndexDsInfo();
            if (idxList == null || idxList.isEmpty()) {
                throw new DirecIndexApiException("Cannot commit index: no public Search Service found");
            }
            if (idxList.size() > 1) {
                log.warn((Object)"Found more than 1 public search service");
            }
            HashMap clients = Maps.newHashMap();
            for (IndexDsInfo i : idxList) {
                clients.put(i, CloudIndexClientFactory.newIndexClient((String)i.getIndexBaseUrl(), (String)i.getColl(), (boolean)false));
            }
            return clients;
        }
        catch (CloudIndexClientException | ISLookUpException | IOException e) {
            throw new DirecIndexApiException(e);
        }
    }

    private List<IndexDsInfo> calculateCurrentIndexDsInfo() throws IOException, ISLookUpException {
        ArrayList list = Lists.newArrayList();
        String queryUrl = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        String queryDs = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        ISLookUpService lu = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);
        List idxDs = lu.quickSearchProfile(queryDs);
        for (String idx : idxDs) {
            String[] arr = idx.split("@@@");
            list.add(new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim()));
        }
        return list;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error in direct index API", (Throwable)e);
        return new ErrorMessage(e);
    }

    public boolean isAutocommitactive() {
        return this.autocommitactive;
    }

    public synchronized void setAutocommitactive(boolean autocommitactive) {
        this.autocommitactive = autocommitactive;
    }

    public long getCommitfrquency() {
        return this.commitfrquency;
    }

    public synchronized void setCommitfrquency(long commitfrquency) {
        if (commitfrquency < COMMIT_FREQUENCY_MINVALUE) {
            throw new RuntimeException("cannot set autocommit frequency: minimum accepted value (inclusive) is " + COMMIT_FREQUENCY_MINVALUE);
        }
        this.commitfrquency = commitfrquency;
        this.updateSchedule();
    }

    public class ErrorMessage {
        private final String message;
        private final String stacktrace;

        public ErrorMessage(Exception e) {
            this(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }

        public ErrorMessage(String message, String stacktrace) {
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }

    public class IndexDsInfo {
        private final String indexBaseUrl;
        private final String indexDsId;
        private final String format;
        private final String coll;

        public IndexDsInfo(String indexBaseUrl, String indexDsId, String format, String coll) {
            this.indexBaseUrl = indexBaseUrl;
            this.indexDsId = indexDsId;
            this.format = format;
            this.coll = coll;
        }

        public String getIndexBaseUrl() {
            return this.indexBaseUrl;
        }

        public String getIndexDsId() {
            return this.indexDsId;
        }

        public String getFormat() {
            return this.format;
        }

        public String getColl() {
            return this.coll;
        }
    }
}

