package eu.dnetlib.openaire.directindex.api;

import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;

public class IndexDSRetriever {

	private static final Log log = LogFactory.getLog(IndexDSRetriever.class);
	@Value(value = "${openaire.api.directindex.findSolrIndexUrl.xquery}")
	private ClassPathResource findSolrIndexUrl;

	@Value(value = "${openaire.api.directindex.findIndexDsInfo.xquery}")
	private ClassPathResource findIndexDsInfo;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Cacheable("indexDsInfo")
	public List<IndexDsInfo> calculateCurrentIndexDsInfo() throws IOException, ISLookUpException {

		log.info("Not using cache");
		final List<IndexDsInfo> list = Lists.newArrayList();

		final String queryUrl = IOUtils.toString(findSolrIndexUrl.getInputStream());
		final String queryDs = IOUtils.toString(findIndexDsInfo.getInputStream());

		final ISLookUpService lu = serviceLocator.getService(ISLookUpService.class);
		final String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);

		final List<String> idxDs = lu.quickSearchProfile(queryDs);
		for (final String idx : idxDs) {
			final String[] arr = idx.split("@@@");
			list.add(new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim()));
		}
		return list;
	}

	@CacheEvict(value="indexDsInfo", allEntries = true)
	public void evictCache(){
		log.info("Evicting indexDsInfo cache");
	}
}