package eu.dnetlib.openaire.directindex.api;

import eu.dnetlib.functionality.index.utils.ZkServers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;

public class IndexClientManager {

    private static final Log log = LogFactory.getLog(IndexClientManager.class);

    private CloudSolrClient client = null;

    public CloudSolrClient getClient(IndexDsInfo info) {

        if (client == null) {
            log.info(String.format("Initializing solr client (%s) with collection %s", info.getIndexBaseUrl(), info.getColl()));
            ZkServers zk = ZkServers.newInstance(info.getIndexBaseUrl());
            CloudSolrClient.Builder builder = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).withParallelUpdates(true);
            client = builder.build();
        }
        client.setDefaultCollection(info.getColl());
        return client;
    }

}