/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;

public class IndexClientMap {
    private static final Log log = LogFactory.getLog(IndexClientMap.class);
    @Value(value="${openaire.api.directindex.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaire.api.directindex.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private Map<IndexDsInfo, CloudIndexClient> clients = Maps.newHashMap();

    public Map<IndexDsInfo, CloudIndexClient> getClients() throws DirecIndexApiException {
        try {
            List<IndexDsInfo> idxList = this.calculateCurrentIndexDsInfo();
            if (idxList == null || idxList.isEmpty()) {
                throw new DirecIndexApiException("cannot create index: no public Search Service found");
            }
            if (idxList.size() > 1) {
                log.warn((Object)"found more than 1 public search service");
            }
            for (IndexDsInfo i : idxList) {
                if (this.clients.containsKey(i)) continue;
                this.clients.put(i, CloudIndexClientFactory.newIndexClient((String)i.getIndexBaseUrl(), (String)i.getColl(), (boolean)false));
            }
            return this.clients;
        }
        catch (CloudIndexClientException | ISLookUpException | IOException e) {
            throw new DirecIndexApiException(e);
        }
    }

    private List<IndexDsInfo> calculateCurrentIndexDsInfo() throws IOException, ISLookUpException {
        ArrayList list = Lists.newArrayList();
        String queryUrl = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        String queryDs = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        ISLookUpService lu = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);
        List idxDs = lu.quickSearchProfile(queryDs);
        for (String idx : idxDs) {
            String[] arr = idx.split("@@@");
            list.add(new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim()));
        }
        return list;
    }
}

