/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenAIRESubmitterUtils {
    private static final Log log = LogFactory.getLog(OpenAIRESubmitterUtils.class);

    public Map<String, String> calculateProjectInfo(String link) {
        HashMap<String, String> info = new HashMap<String, String>();
        String[] arr = link.split("/");
        if (arr.length > 4) {
            String acronym;
            String string = acronym = arr.length > 7 ? arr[7] : "";
            String title = arr.length > 6 ? (StringUtils.isNotBlank((String)arr[6]) ? arr[6] : acronym) : "";
            String jurisdiction = arr.length > 5 ? arr[5] : "";
            String funderId = this.calculateFunderId(arr[2], arr[3]);
            info.put("id", this.calculateProjectId(arr[2], arr[3], arr[4]));
            info.put("funderShortName", arr[2]);
            info.put("fundingName", arr[3]);
            info.put("code", arr[4]);
            info.put("jurisdiction", jurisdiction);
            info.put("title", title);
            info.put("acronym", acronym);
            info.put("funderId", funderId);
            info.put("funderName", this.calculateFunderName(arr[2]));
            info.put("fundingId", funderId + "::" + arr[3]);
        }
        return info;
    }

    protected String calculateFunderPrefix(String funderShortName, String funding) {
        switch (funderShortName.toLowerCase()) {
            case "conicyt": {
                return "conicytf____::";
            }
            case "ec": {
                if (funding.equalsIgnoreCase("fp7")) {
                    return "corda_______::";
                }
                return "corda__h2020::";
            }
            case "hrzz": 
            case "mzos": {
                return "irb_hr______::";
            }
            case "tara": {
                return "taraexp_____::";
            }
            case "tubitak": {
                return "tubitakf____::";
            }
        }
        String prefix = funderShortName.toLowerCase();
        while (prefix.length() < 12) {
            prefix = prefix + "_";
        }
        return prefix + "::";
    }

    protected String calculateProjectId(String funderShortName, String funding, String code) {
        String suffix = Hashing.md5((String)code);
        String funderPrefix = this.calculateFunderPrefix(funderShortName, funding);
        return funderPrefix + suffix;
    }

    protected String calculateFunderId(String funderShortName, String funding) {
        switch (funderShortName.toLowerCase()) {
            case "ec": {
                return "ec__________::EC";
            }
        }
        String prefix = this.calculateFunderPrefix(funderShortName, funding);
        return prefix + funderShortName.toUpperCase();
    }

    protected String calculateFunderName(String funderShortName) {
        switch (funderShortName.toLowerCase()) {
            case "aff": 
            case "aka": {
                return "Academy of Finland";
            }
            case "arc": {
                return "Australian Research Council (ARC)";
            }
            case "conicyt": {
                return "Comisi\u00f3n Nacional de Investigaci\u00f3n Cient\u00edfica y Tecnol\u00f3gica";
            }
            case "ec": {
                return "European Commission";
            }
            case "fct": {
                return "Funda\u00e7\u00e3o para a Ci\u00eancia e a Tecnologia, I.P.";
            }
            case "fwf": {
                return "Austrian Science Fund (FWF)";
            }
            case "hrzz": {
                return "Croatian Science Foundation (CSF)";
            }
            case "mestd": {
                return "Ministry of Education, Science and Technological Development of Republic of Serbia";
            }
            case "miur": {
                return "Ministero dell'Istruzione dell'Universit\u00e0 e della Ricerca";
            }
            case "mzos": {
                return "Ministry of Science, Education and Sports of the Republic of Croatia (MSES)";
            }
            case "nhmrc": {
                return "National Health and Medical Research Council (NHMRC)";
            }
            case "nih": {
                return "National Institutes of Health";
            }
            case "nsf": {
                return "National Science Foundation";
            }
            case "nwo": {
                return "Netherlands Organisation for Scientific Research (NWO)";
            }
            case "rcuk": {
                return "Research Council UK";
            }
            case "sfi": {
                return "Science Foundation Ireland";
            }
            case "sgov": {
                return "Gobierno de Espa\u00f1a";
            }
            case "snsf": {
                return "Swiss National Science Foundation";
            }
            case "tara": {
                return "Tara Expeditions Foundation";
            }
            case "tubitak": {
                return "T\u00fcrkiye Bilimsel ve Teknolojik Ara\u015ft\u0131rma Kurumu";
            }
            case "wt": {
                return "Wellcome Trust";
            }
        }
        log.error((Object)("Funder short name '" + funderShortName + "' not managed"));
        return "";
    }

    public List<ContextInfo> processContexts(List<String> list) {
        return Lists.newArrayList((Iterable)Lists.transform(list, (Function)new Function<String, ContextInfo>(){

            public ContextInfo apply(String s) {
                return this.createContextInfo(s.split("::"), 0);
            }

            private ContextInfo createContextInfo(String[] arr, int pos) {
                StringWriter id = new StringWriter();
                id.write(arr[0]);
                for (int i = 0; i < pos; ++i) {
                    id.write("::");
                    id.write(arr[i + 1]);
                }
                String elem = pos == 0 ? "context" : (pos == 1 ? "category" : "concept");
                ContextInfo info = new ContextInfo(elem, id.toString());
                if (pos + 1 < arr.length) {
                    info.getChildren().add(this.createContextInfo(arr, pos + 1));
                }
                return info;
            }
        }));
    }

    public class ContextInfo {
        private String elem;
        private String id;
        private List<ContextInfo> children = new ArrayList<ContextInfo>();

        public ContextInfo(String elem, String id) {
            this.elem = elem;
            this.id = id;
        }

        public String getElem() {
            return this.elem;
        }

        public void setElem(String elem) {
            this.elem = elem;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ContextInfo> getChildren() {
            return this.children;
        }

        public void setChildren(List<ContextInfo> children) {
            this.children = children;
        }

        public boolean isRoot() {
            return this.elem.equals("context");
        }
    }
}

