/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.common.collect.Sets;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.openaire.directindex.objects.ZenodoContextList;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OpenAIRESubmitterUtils {
    private static final Log log = LogFactory.getLog(OpenAIRESubmitterUtils.class);
    private static final String ZENODO_COMMUNITY = "zenodo.org/communities/";
    private String community_api;

    public OpenAIRESubmitterUtils(String community_api) {
        this.community_api = community_api;
    }

    public Map<String, String> calculateProjectInfo(String link) {
        HashMap<String, String> info = new HashMap<String, String>();
        String[] arr = link.split("/");
        if (arr.length > 4) {
            String acronym;
            String string = acronym = arr.length > 7 ? arr[7] : "";
            String title = arr.length > 6 ? (StringUtils.isNotBlank((String)arr[6]) ? arr[6] : acronym) : "";
            String jurisdiction = arr.length > 5 ? arr[5] : "";
            String funderId = this.calculateFunderId(arr[2], arr[3]);
            info.put("id", this.calculateProjectId(arr[2], arr[3], arr[4]));
            info.put("funderShortName", this.fixFunderShortName(arr[2]));
            info.put("fundingName", arr[3]);
            info.put("code", this.unescape(arr[4]));
            info.put("jurisdiction", jurisdiction);
            info.put("title", title);
            info.put("acronym", acronym);
            info.put("funderId", funderId);
            info.put("funderName", this.calculateFunderName(arr[2]));
            if (StringUtils.isNotBlank((String)arr[3])) {
                info.put("fundingId", funderId + "::" + arr[3]);
            }
        }
        return info;
    }

    protected String fixFunderShortName(String funderShortName) {
        switch (funderShortName) {
            case "RCUK": {
                return "UKRI";
            }
        }
        return funderShortName;
    }

    protected String calculateFunderPrefix(String funderShortName, String funding) {
        switch (funderShortName.toLowerCase()) {
            case "conicyt": {
                return "conicytf____::";
            }
            case "dfg": {
                return "dfgf________::";
            }
            case "ec": {
                if (funding.equalsIgnoreCase("fp7")) {
                    return "corda_______::";
                }
                return "corda__h2020::";
            }
            case "eea": {
                return "euenvagency_::";
            }
            case "hrzz": 
            case "mzos": {
                return "irb_hr______::";
            }
            case "tara": {
                return "taraexp_____::";
            }
            case "tubitak": {
                return "tubitakf____::";
            }
            case "rcuk": {
                return "ukri________::";
            }
        }
        String prefix = funderShortName.toLowerCase();
        while (prefix.length() < 12) {
            prefix = prefix + "_";
        }
        return prefix + "::";
    }

    protected String calculateProjectId(String funderShortName, String funding, String code) {
        String suffix = Hashing.md5((String)this.unescape(code));
        String funderPrefix = this.calculateFunderPrefix(funderShortName, funding);
        return funderPrefix + suffix;
    }

    private String unescape(String code) {
        return StringUtils.replaceChars((String)code, (String)"%2F", (String)"/");
    }

    protected String calculateFunderId(String funderShortName, String funding) {
        switch (funderShortName.toLowerCase()) {
            case "ec": {
                return "ec__________::EC";
            }
        }
        String fixedFunderShortName = this.fixFunderShortName(funderShortName);
        String prefix = this.calculateFunderPrefix(fixedFunderShortName, funding);
        return prefix + fixedFunderShortName.toUpperCase();
    }

    protected String calculateFunderName(String funderShortName) {
        switch (funderShortName.toLowerCase()) {
            case "aff": 
            case "aka": {
                return "Academy of Finland";
            }
            case "anr": {
                return "French National Research Agency (ANR)";
            }
            case "arc": {
                return "Australian Research Council (ARC)";
            }
            case "cihr": {
                return "Canadian Institutes of Health Research";
            }
            case "conicyt": {
                return "Comisi\u00f3n Nacional de Investigaci\u00f3n Cient\u00edfica y Tecnol\u00f3gica";
            }
            case "dfg": {
                return "Deutsche Forschungsgemeinschaft";
            }
            case "ec": {
                return "European Commission";
            }
            case "eea": {
                return "European Environment Agency";
            }
            case "fct": {
                return "Funda\u00e7\u00e3o para a Ci\u00eancia e a Tecnologia, I.P.";
            }
            case "fwf": {
                return "Austrian Science Fund (FWF)";
            }
            case "gsrt": {
                return "General Secretariat of Research and Technology (GSRT)";
            }
            case "hrzz": {
                return "Croatian Science Foundation (CSF)";
            }
            case "innoviris": {
                return "INNOVIRIS";
            }
            case "mestd": {
                return "Ministry of Education, Science and Technological Development of Republic of Serbia";
            }
            case "miur": {
                return "Ministero dell'Istruzione dell'Universit\u00e0 e della Ricerca";
            }
            case "mzos": {
                return "Ministry of Science, Education and Sports of the Republic of Croatia (MSES)";
            }
            case "nhmrc": {
                return "National Health and Medical Research Council (NHMRC)";
            }
            case "nih": {
                return "National Institutes of Health";
            }
            case "nsf": {
                return "National Science Foundation";
            }
            case "nserc": {
                return "Natural Sciences and Engineering Research Council of Canada";
            }
            case "nwo": {
                return "Netherlands Organisation for Scientific Research (NWO)";
            }
            case "rcuk": 
            case "ukri": {
                return "UK Research and Innovation";
            }
            case "rif": 
            case "rpf": {
                return "Research and Innovation Foundation";
            }
            case "rsf": {
                return "Russian Science Foundation";
            }
            case "sfi": {
                return "Science Foundation Ireland";
            }
            case "sgov": {
                return "Gobierno de Espa\u00f1a";
            }
            case "snsf": {
                return "Swiss National Science Foundation";
            }
            case "sshrc": {
                return "Social Sciences and Humanities Research Council";
            }
            case "tara": {
                return "Tara Expeditions Foundation";
            }
            case "tubitak": {
                return "T\u00fcrkiye Bilimsel ve Teknolojik Ara\u015ft\u0131rma Kurumu";
            }
            case "wt": {
                return "Wellcome Trust";
            }
        }
        log.error((Object)("Funder short name '" + funderShortName + "' not managed"));
        return "";
    }

    public Collection<String> translateZenodoCommunity(String community) {
        if (community.contains(ZENODO_COMMUNITY)) {
            String context = community.substring(community.lastIndexOf("/") + 1);
            RestTemplate rt = new RestTemplate();
            try {
                return new HashSet<String>(((ZenodoContextList)rt.getForObject(this.community_api + context + "/openairecommunities", ZenodoContextList.class, new Object[0])).getOpenAirecommunitylist());
            }
            catch (RestClientException rce) {
                log.error((Object)("Unable to get object for " + this.community_api + context + "/openairecommunities"));
                return new HashSet<String>();
            }
        }
        return Sets.newHashSet((Object[])new String[]{community});
    }

    private ContextInfo createContextInfo(String[] arr, int pos, Map<String, String> labelMap) {
        StringWriter id = new StringWriter();
        id.write(arr[0]);
        for (int i = 0; i < pos; ++i) {
            id.write("::");
            id.write(arr[i + 1]);
        }
        String label = labelMap.get(id.toString());
        String elem = pos == 0 ? "context" : (pos == 1 ? "category" : "concept");
        ContextInfo info = new ContextInfo(elem, id.toString(), label);
        if (pos + 1 < arr.length) {
            info.getChildren().add(this.createContextInfo(arr, pos + 1, labelMap));
        }
        return info;
    }

    public List<ContextInfo> processContexts(List<String> zenodoCommunities, Map<String, String> labelMap) {
        return zenodoCommunities.stream().map(c -> this.translateZenodoCommunity((String)c)).flatMap(coll -> coll.stream()).map(ctx -> this.createContextInfo(ctx.split("::"), 0, labelMap)).filter(info -> StringUtils.isNotBlank((String)info.getLabel())).collect(Collectors.toList());
    }

    public class ContextInfo {
        private String elem;
        private String id;
        private String label;
        private List<ContextInfo> children = new ArrayList<ContextInfo>();

        public ContextInfo(String elem, String id, String label) {
            this.elem = elem;
            this.id = id;
            this.label = label;
        }

        public String getElem() {
            return this.elem;
        }

        public void setElem(String elem) {
            this.elem = elem;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ContextInfo> getChildren() {
            return this.children;
        }

        public void setChildren(List<ContextInfo> children) {
            this.children = children;
        }

        public boolean isRoot() {
            return this.elem.equals("context");
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

