package eu.dnetlib.openaire.directindex.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ResultSubmitterService {

    private static final Log log = LogFactory.getLog(ResultSubmitterService.class);

    @Autowired
    private IndexDSRetriever indexDSRetriever;

    @Resource(name = "indexClientManager")
    private IndexClientManager clientManager;

    /**
     * Autocommit feature activation flag
     */
    @Value(value = "${openaire.api.directindex.autocommit.active}")
    private boolean autocommitactive;

    /**
     * Autocommit frequency (Seconds)
     */
    @Value(value = "${openaire.api.directindex.autocommit.frequency}")
    private long commitfrquency = 60;

    private ScheduledExecutorService executor;

    public ResultSubmitterService() {
        executor = Executors.newSingleThreadScheduledExecutor();
        updateCommitSchedule();
    }

    private void updateCommitSchedule() {
        log.info("updating commit schedule");

        executor.scheduleAtFixedRate(() -> {
            if (isAutocommitactive()) {
                try {
                    IndexDsInfo info = indexDSRetriever.calculateCurrentIndexDsInfo();
                    CloudSolrClient client = clientManager.getClient(info);
                    log.info("performing commit on " + info.getColl());
                    client.commit();
                } catch (Throwable e) {
                    log.error("unable to perform commit", e);
                }
            }
        }, 0, getCommitfrquency(), TimeUnit.SECONDS);
    }

    public boolean isAutocommitactive() {
        return autocommitactive;
    }

    public synchronized void setAutocommitactive(boolean autocommitactive) {
        this.autocommitactive = autocommitactive;
    }

    public long getCommitfrquency() {
        return commitfrquency;
    }

    public synchronized void setCommitfrquency(long commitfrquency) {
        this.commitfrquency = commitfrquency;
    }

}
