package eu.dnetlib.openaire.directindex.objects;

import eu.dnetlib.miscutils.functional.hash.Hashing;
import org.apache.commons.lang.StringUtils;

/**
 * Created by michele on 02/12/15.
 */
public class DatasourceEntry {

	private String id;
	private String name;
	private String prefix;

	public DatasourceEntry() {
	}

	public DatasourceEntry(final String id, final String name, final String prefix) {
		this.id = id;
		this.name = name;
		this.prefix = prefix;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(final String prefix) {
		this.prefix = prefix;
	}

	public String calculateOpenaireId() {
		if (StringUtils.isNotBlank(id)) {
			final String[] arr = id.split("::");
			if (arr.length == 2) {
				return String.format("%s::%s", arr[0], Hashing.md5(arr[1]));
			}
		}
		return "";
	}
}