/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetexploremetrics.dao;

import eu.dnetlib.dnetexploremetrics.dao.MetricsDAO;
import eu.dnetlib.dnetexploremetrics.model.Metrics;
import eu.dnetlib.dnetexploremetrics.utils.PrometheusMetricsFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class MetricsFileDAO
implements MetricsDAO {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Value(value="${filepath:/var/lib/tomcat_dnet/8980/webapps}")
    private String filePath;

    public void save(Metrics metrics) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            File file = new File(this.filePath + "/metrics.txt");
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(PrometheusMetricsFormatter.formatMetrics((Metrics)metrics));
            printWriter.close();
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Error writing metrics to file " + this.filePath + "/metrics.txt."), (Throwable)ioe);
        }
    }

    public String getMetrics() {
        String metrics = "";
        try {
            FileInputStream inputStream = new FileInputStream(this.filePath + "/metrics.txt");
            metrics = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Error reading metrics to file " + this.filePath + "/metrics.txt."), (Throwable)ioe);
        }
        return metrics;
    }
}

