<%@page import="java.util.List"%>
<%@page import="eu.dnetlib.domain.EPR"%>
<%@page import="gr.uoa.di.driver.enabling.resultset.ResultSet"%>
<%@page import="org.apache.commons.lang.StringEscapeUtils"%>

<jsp:useBean id="query" class="eu.dnetlib.data.search.web.Query" scope="request">
<jsp:setProperty name="query" property="*"/>
</jsp:useBean>

<%
if (query == null) {
%>
    <jsp:forward page="/"/>
<%
}
%>


<%@page import="eu.dnetlib.api.data.SearchService"%>
<%@page import="org.springframework.web.context.support.WebApplicationContextUtils"%>
<%@page import="org.springframework.context.ApplicationContext"%>
<%@page import="eu.dnetlib.data.search.web.SearchServiceContextUtils"%>
<%@page import="gr.uoa.di.driver.enabling.resultset.ResultSetFactory"%>
<html>
	<head>
		<title>Index Lookup</title>
	</head>
	<body>
		<h1>Index Lookup</h1>
		Search for <b>
		<%
		if (query.getQuery() == null || query.getQuery().length() == 0 ) {
		%>
			(empty query)
		<%
		} else {
		%>
			<%=query.getQuery()%>
		<%
		}
		%>
		</b> in <a href="services/searchWebService">local search service</a>...<br>

<%
	long time = System.currentTimeMillis();
	SearchService searchService = SearchServiceContextUtils.getSearchService(request);
%>
	Created index endpoint in <%=System.currentTimeMillis()-time%> ms.<br>

<%
	time = System.currentTimeMillis();
	EPR epr = searchService.search(query.getQuery());
%>
	Index lookup lasted <%=System.currentTimeMillis()-time%> ms.<br>
	Returned EPR: <pre><%=StringEscapeUtils.escapeHtml(epr.toString())%></pre><br>
<%
	time = System.currentTimeMillis();
	ResultSet<String> rs = SearchServiceContextUtils.getResultSetFactory(request).createResultSet(epr);
	int count = rs.size();
%>
	Total documents in result set: <%=count%><br>
	Query Numof Documents lasted <%=System.currentTimeMillis()-time%> ms.<br>

<%
	time = System.currentTimeMillis();
	List<String> list = null;
	int MAX = 50;
	if (count > 0) {
		list = rs.getElements(1, Math.min(MAX, count));
	}
%>
	Retrieve top-<%=MAX%> docs lasted <%=System.currentTimeMillis()-time%> ms.<br>

	Top-<%=MAX%> results:
	<table>
		<tr><th>Count</th><th>Record</th></tr>
	<% for (int i = 0 ; i < MAX && i < count; i++ ) { %>
		<tr>
			<td><%=i+1%></td>
			<!--
			<td><pre><%=StringEscapeUtils.escapeHtml(list.get(i))%></pre></td>
			-->
			<td><pre><%=StringEscapeUtils.escapeHtml(
					SearchServiceContextUtils.prettyPrint(list.get(i)))%>
			</pre></td>
		</tr>
	<% } %>
	</table>
	
	</body>
</html>

