package eu.dnetlib.functionality.index.client;

import java.util.List;

import javax.annotation.Resource;

/**
 * The Class GlobalIndexClientFactory.
 */

/**
 * The Class ResolvingIndexClientFactory.
 */
public class ResolvingIndexClientFactory {

	/** The index client factories. */
	@Resource
	private List<IndexClientFactory> indexClientFactories;

	/**
	 * Gets the client.
	 * 
	 * @param format
	 *            the format
	 * @param layout
	 *            the layout
	 * @param interpretation
	 *            the interpretation
	 * @param backendId
	 *            the backend id
	 * @return the client
	 * @throws IndexClientException
	 *             the index client exception
	 */
	public IndexClient getClient(final String format, final String layout, final String interpretation, final String backendId) throws IndexClientException {
		for (IndexClientFactory factory : indexClientFactories) {
			if (factory.getBackendId().equalsIgnoreCase(backendId)) { return factory.getClient(format, layout, interpretation); }
		}
		throw new IndexClientException("No client for backendId: " + backendId);
	}

}
