/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.client.solr;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.dnetlib.functionality.index.client.AbstractIndexClientFactory;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.IndexClientFactory;
import eu.dnetlib.functionality.index.client.solr.SolrIndexClient;
import eu.dnetlib.functionality.index.query.SolrIndexQueryFactory;
import eu.dnetlib.functionality.index.query.SolrIndexQueryResponseFactory;
import eu.dnetlib.functionality.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.MetadataReferenceFactory;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SolrIndexClientFactory
extends AbstractIndexClientFactory
implements IndexClientFactory {
    private static String ID = "id";
    private String configuration;
    protected Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> serviceProperties;
    @Autowired
    private SolrIndexQueryFactory solrIndexQueryFactory;
    @Autowired
    private SolrIndexQueryResponseFactory solrIndexQueryResponseFactory;
    @Autowired
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    @Override
    public void init() throws IndexClientException {
        try {
            this.serviceProperties = (Map)new Gson().fromJson(this.getConfiguration(), this.typeToken);
        }
        catch (Throwable e) {
            throw new IndexClientException("unable to parse configuration: " + this.getConfiguration(), e);
        }
    }

    @Override
    public String getBackendId() {
        return this.serviceProperties.get(ID);
    }

    @Override
    public IndexClient getClient(String format, String layout, String interpretation) throws IndexClientException {
        return new SolrIndexClient(format, layout, interpretation, this.isQueryTools.getIndexProperties(this.getBackendId()), this.solrIndexQueryFactory, this.solrIndexQueryResponseFactory, this.tMapFactory);
    }

    @Override
    public IndexClient getClient(MetadataReference mdRef) throws IndexClientException {
        return this.getClient(mdRef.getFormat(), mdRef.getLayout(), mdRef.getInterpretation());
    }

    @Override
    public IndexClient getClient(String collection) throws IndexClientException {
        return this.getClient(MetadataReferenceFactory.decodeMetadata(collection));
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @Required
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }
}

