/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.query;

import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.query.IndexQuery;
import eu.dnetlib.functionality.index.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.query.Pruner;
import eu.dnetlib.functionality.index.query.QueryLanguage;
import eu.dnetlib.functionality.index.query.SolrIndexQuery;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolrIndexQueryFactory
extends IndexQueryFactory {
    private static final Log log = LogFactory.getLog(SolrIndexQueryFactory.class);
    private static final String SERVICE_HIGHLIGHT_ENABLE = "service.index.solr.highlight.enable";

    @Override
    protected IndexQuery newInstance(TranslatedQuery cql, Pruner.Result res, QueryLanguage lang) {
        switch (lang) {
            case CQL: {
                return new SolrIndexQuery(cql, res.getOptionMap());
            }
            case SOLR: {
                return new SolrIndexQuery(res.getNode().toCQL(), res.getOptionMap());
            }
        }
        throw new IllegalArgumentException("invalid query language: " + (Object)((Object)lang));
    }

    @Override
    protected IndexQuery setQueryOptions(IndexQuery indexQuery, IndexClient client) {
        SolrIndexQuery solrQuery = (SolrIndexQuery)indexQuery;
        boolean isHighlightEnabled = Boolean.parseBoolean(client.getServiceProperties().get(SERVICE_HIGHLIGHT_ENABLE));
        if (solrQuery.getHighlight() & isHighlightEnabled) {
            solrQuery.setHighlightFragsize(0).setHighlightSnippets(1).setHighlightSimplePre("[hl]").setHighlightSimplePost("[/hl]").addHighlightField("__result").addField("__indexrecordidentifier");
        }
        solrQuery.addField("__result");
        if (solrQuery.getFacetFields() != null) {
            log.debug((Object)("getFacetFields() " + Arrays.asList(solrQuery.getFacetFields())));
            solrQuery.setFacetMinCount(1);
        }
        return solrQuery;
    }
}

