/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.query;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.provision.index.rmi.BrowsingRow;
import eu.dnetlib.functionality.index.model.document.IndexDocument;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Collection;
import java.util.List;

public abstract class QueryResponseParser {
    protected final UnaryFunction<String, String> highlightUtils;
    protected final BiMap<String, String> aliases;
    protected final boolean returnEmptyFields;
    protected final boolean includeRanking;
    protected final UnaryFunction<String, IndexDocument> wrapperRank = doc -> this.addRanking(this.getSingleField((IndexDocument)doc, "__result"), this.getSingleField((IndexDocument)doc, "score"));
    protected final UnaryFunction<String, IndexDocument> wrapperNoRank = doc -> this.wrap(this.getSingleField((IndexDocument)doc, "__result"));

    private String getSingleField(IndexDocument doc, String fieldName) {
        Object value = doc.getFieldValue(fieldName);
        if (value instanceof Collection) {
            return (String)Iterables.getOnlyElement((Iterable)((Iterable)value));
        }
        return String.valueOf(value);
    }

    public QueryResponseParser(UnaryFunction<String, String> highlightUtils, BiMap<String, String> aliases, boolean returnEmptyFields, boolean includeRanking) {
        this.highlightUtils = highlightUtils;
        this.aliases = aliases;
        this.returnEmptyFields = returnEmptyFields;
        this.includeRanking = includeRanking;
    }

    private String addRanking(String doc, String score) {
        return new String("<record rank=\"" + score + "\">" + doc + "</record>");
    }

    private String wrap(String doc) {
        return new String("<record>" + doc + "</record>");
    }

    public abstract long getNumFound();

    public abstract int getQueryTime();

    public abstract long getElapsedTime();

    public abstract String getStatus();

    public abstract long getStart();

    public abstract int getCurrentSize();

    public abstract List<String> getResults();

    public abstract Long getNumberOfBrowsingResults();

    public abstract List<BrowsingRow> getBrowsingResults();

    public BiMap<String, String> getAliases() {
        return this.aliases;
    }
}

