/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.utils;

import com.google.common.collect.Maps;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.utils.IndexConfigFactory;
import eu.dnetlib.functionality.index.utils.IndexSchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ZkUtils {
    private static final Log log = LogFactory.getLog(ZkUtils.class);
    private static final String CONFIGS_PATH = "/configs";
    @Autowired
    private IndexSchemaFactory schemaFactory;
    private IndexConfigFactory configFactory;
    private String staticConfigurationClasspath;

    public void uploadZookeperConfig(SolrZkClient zkClient, String coreName, Document fields, Map<String, String> params, boolean overwrite) {
        String basepath = "/configs/" + coreName;
        log.info((Object)("uploading solr configuration to ZK for index collection: " + coreName));
        try {
            if (overwrite && zkClient.getSolrZooKeeper().exists(basepath, false) != null) {
                log.info((Object)("cleanup ZK configuration: " + coreName));
                for (String child : zkClient.getSolrZooKeeper().getChildren(basepath, false)) {
                    String path = basepath + "/" + child;
                    log.debug((Object)("cleanup ZK file: " + path));
                    zkClient.delete(path, -1, true);
                }
                zkClient.delete(basepath, -1, true);
            }
            if (!zkClient.exists(basepath, true).booleanValue()) {
                log.info((Object)("upload ZK configuration: " + coreName));
                zkClient.makePath(basepath, true);
                this.uploadConfiguration(zkClient, basepath, this.buildConfiguration(coreName, fields, params));
            }
            log.info((Object)"upload ZK configuration complete");
        }
        catch (Exception e) {
            log.error((Object)"unable to upload solr configuration", (Throwable)e);
        }
    }

    private Map<String, byte[]> buildConfiguration(String indexName, Document fields, Map<String, String> params) throws IndexServiceException {
        HashMap res = Maps.newHashMap();
        try {
            Resource[] resources;
            log.debug((Object)"adding schema.xml to the resource map");
            res.put("schema.xml", this.schemaFactory.getSchema(fields).getBytes());
            res.put("solrconfig.xml", this.configFactory.getConfig(params).getBytes());
            log.debug((Object)"adding solrconfig.xml to the resource map");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource r : resources = resolver.getResources(this.getStaticConfigurationClasspath())) {
                InputStream is = r.getInputStream();
                if (r.getFilename() == null || r.getFilename().isEmpty()) continue;
                res.put(r.getFilename(), IOUtils.toByteArray((InputStream)is));
                log.debug((Object)("adding " + r.getFilename() + " to the resource map"));
                is.close();
            }
            return res;
        }
        catch (Throwable e) {
            throw new IndexServiceException("failed to build configuration", e);
        }
    }

    private void uploadConfiguration(SolrZkClient zkClient, String basePath, Map<String, byte[]> resources) throws KeeperException, InterruptedException, IOException {
        if (!zkClient.exists(basePath, true).booleanValue()) {
            zkClient.makePath(basePath, true);
        }
        for (Map.Entry<String, byte[]> e : resources.entrySet()) {
            String path = basePath + "/" + e.getKey();
            log.debug((Object)("upload ZK configuration: " + path));
            zkClient.create(path, e.getValue(), CreateMode.PERSISTENT, true);
        }
    }

    public IndexConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    @Required
    public void setConfigFactory(IndexConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    public String getStaticConfigurationClasspath() {
        return this.staticConfigurationClasspath;
    }

    @Required
    public void setStaticConfigurationClasspath(String staticConfigurationClasspath) {
        this.staticConfigurationClasspath = staticConfigurationClasspath;
    }
}

