/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.utils;

import com.google.common.collect.Maps;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class IndexConfigFactory {
    private static final Log log = LogFactory.getLog(IndexConfigFactory.class);
    private StringTemplate solrConfig;

    public String getConfig(Map<String, String> params) throws IndexServiceException {
        StringTemplate conf = new StringTemplate(this.getSolrConfig().getTemplate());
        for (Map.Entry<String, String> e : this.filter(params).entrySet()) {
            log.debug((Object)("setting conf property [" + e.getKey() + ":" + e.getValue() + "]"));
            conf.setAttribute(e.getKey(), (Object)e.getValue());
        }
        return conf.toString();
    }

    private Map<String, String> filter(Map<String, String> params) {
        return Maps.filterKeys(params, input -> CONFIG_PARAMS.isValid(input));
    }

    public StringTemplate getSolrConfig() {
        return this.solrConfig;
    }

    @Required
    public void setSolrConfig(StringTemplate solrConfig) {
        this.solrConfig = solrConfig;
    }

    public static enum CONFIG_PARAMS {
        luceneMatchVersion;


        static boolean isValid(String v) {
            try {
                CONFIG_PARAMS.valueOf(v);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

