<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:for-each select="//field">
			<xsl:variable name="field" select="@name"></xsl:variable>
			<xsl:variable name="label" select="@label"></xsl:variable>
				<table class="table table-striped" ng-hide="browse_{$field}_showAll">
					<xsl:for-each select="./value">
						<tr ng-hide="browse_{$field}_showAll">
							<th><a href="javascript:void(0)" data-dismiss="modal" ng-click="updateQueryWithValue('{$field}', '{@name}', 1500)"><xsl:value-of select="@name" /></a></th>
							<td class="text-right"><xsl:value-of select="@size" /></td>
						</tr>
					</xsl:for-each>
				</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>