/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.ProtocolParameterValue;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParamImpl;
import eu.dnetlib.enabling.datasources.common.BrowseTerm;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.SearchApisEntry;
import eu.dnetlib.enabling.datasources.common.SimpleDatasource;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.error.ErrorMessage;
import eu.dnetlib.functionality.modular.ui.repositories.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class RepoInternalController {
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?>, Api<?>> dsManager;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private RepoUIUtils repoUIUtils;
    private static final Log log = LogFactory.getLog(RepoInternalController.class);

    @RequestMapping(value={"/ui/browseRepoField.do"})
    @ResponseBody
    public List<? extends BrowseTerm> browseRepoField(@RequestParam(value="field", required=true) String field) throws Exception {
        return this.dsManager.browseField(field);
    }

    @Cacheable(cacheNames={"repoUIJsonCache"}, key="#param, #value", condition="#refresh == false")
    @RequestMapping(value={"/ui/listApis.do"})
    @ResponseBody
    public List<? extends SearchApisEntry> listApis(@RequestParam(value="param", required=true) String param, @RequestParam(value="value", required=true) String value, @RequestParam(value="refresh", required=false) String refresh) throws Exception {
        return this.dsManager.searchApis(param, (Object)value);
    }

    @RequestMapping(value={"/ui/listRepositories.json"})
    @ResponseBody
    public List<SimpleDatasource> listRepositories(@RequestParam(value="type", required=true) String type) throws Exception {
        return this.dsManager.searchDatasourcesByType(type);
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/validateRepo.do"})
    @ResponseBody
    public String listRepositories(@RequestParam(value="id", required=true) String id, @RequestParam(value="b", required=true) boolean b) throws Exception {
        String query = "count(/*[.//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//DATAPROVIDER/@id='" + id + "'])";
        if (!b && Integer.parseInt(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query)) > 0) {
            throw new Exception("Repo " + id + " can be invalidated: it is related to some metawfs");
        }
        String newId = b ? ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).validateProfile(id) : ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).invalidateProfile(id);
        return newId;
    }

    @RequestMapping(value={"/ui/getRepoDetails.do"})
    public void getRepoDetails(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String profile;
        try {
            profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/*[.//DATASOURCE_ORIGINAL_ID='" + id + "']");
        }
        ApplyXslt xslt = new ApplyXslt(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/ui/repositories/xslt/repoDetails.xslt")));
        IOUtils.copy((Reader)new StringReader(xslt.evaluate((Object)profile)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/repoMetaWf.new"})
    @ResponseBody
    public String newDataProviderWorkflow(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="name", required=true) String repoName, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="wf", required=true) String wfId) throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("dataprovider:id", repoId);
        params.put("dataprovider:name", repoName);
        params.put("dataprovider:interface", ifaceId);
        return this.workflowExecutor.startProcess(wfId, (Map)params);
    }

    @RequestMapping(value={"/ui/repoMetaWf.destroy"})
    @ResponseBody
    public String destroyDataProviderWorkflow(@RequestParam(value="destroyWf", required=true) String destroyWfId) throws Exception {
        return this.workflowExecutor.startProcess(destroyWfId, null);
    }

    @RequestMapping(value={"/ui/repoApi.get"})
    @ResponseBody
    public RepoInterfaceEntry getRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="ifaceId", required=true) String ifaceId) throws Exception {
        try {
            return this.repoUIUtils.getApi(repoId, ifaceId);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)String.format("the Interface '%s' is not available for repository '%s', try to sync DB and profiles via the DatasourceManager", ifaceId, repoId));
            this.dsManager.setActive(repoId, ifaceId, this.dsManager.isActive(repoId, ifaceId));
            return this.repoUIUtils.getApi(repoId, ifaceId);
        }
    }

    @RequestMapping(value={"/ui/repoApi.update"})
    @ResponseBody
    public boolean updateRepoApi(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="accessParams", required=false) String accessParamsJson, @RequestParam(value="mdIdPath", required=false) String mdIdPath) throws Exception {
        if (!StringUtils.isEmpty((String)accessParamsJson)) {
            Map params = (Map)new Gson().fromJson(accessParamsJson, new TypeToken<Map<String, String>>(){}.getType());
            String baseUrl = (String)params.remove("baseUrl");
            this.dsManager.updateApiDetails(repoId, ifaceId, mdIdPath, baseUrl, params);
        }
        return true;
    }

    @RequestMapping(value={"/ui/repoApi.delete"})
    @ResponseBody
    public boolean updateRepoApi(@RequestParam(value="repo", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        this.dsManager.deleteApi(repoId, ifaceId);
        return true;
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/repoApiCompliance.update"})
    @ResponseBody
    public boolean updateRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="compliance", required=true) String compliance) throws Exception {
        log.debug((Object)("SET COMPLIANCE TO " + compliance));
        this.dsManager.updateCompliance(repoId, ifaceId, compliance, true);
        return true;
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/repoApiCompliance.reset"})
    @ResponseBody
    public boolean resetRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        log.debug((Object)"RESET COMPLIANCE");
        this.dsManager.updateCompliance(repoId, ifaceId, null, true);
        return true;
    }

    @RequestMapping(value={"/ui/repos/repoApi.html"})
    public void resetRepoApiCompliance(ModelMap map) throws Exception {
    }

    @RequestMapping(value={"/ui/repoApi.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceJson) throws DsmException {
        Api iface = (Api)new Gson().fromJson(ifaceJson, new TypeToken<Api<ApiParamImpl>>(){}.getType());
        iface.setDatasource(repoId);
        log.info((Object)("Adding api " + iface.getId() + " to repository " + repoId));
        this.dsManager.addApi(iface);
        return true;
    }

    @RequestMapping(value={"/ui/repo.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repo", required=true) String repoJson) throws DsmException {
        Datasource ds = (Datasource)new Gson().fromJson(repoJson, new TypeToken<Datasource<Organization<?>, Identity>>(){}.getType());
        java.util.Date now = new java.util.Date();
        ds.setDateofcollection(new Date(now.getTime()));
        if (StringUtils.isBlank((String)ds.getEnglishname())) {
            ds.setEnglishname(ds.getOfficialname());
        }
        log.info((Object)("Adding datasource " + ds.getId() + " - name " + ds.getOfficialname()));
        this.dsManager.saveDs(ds);
        return true;
    }

    @RequestMapping(value={"/ui/listValidValuesForParam.do"})
    @ResponseBody
    public List<ProtocolParameterValue> listValidValuesForParam(@RequestParam(value="protocol", required=true) String protocol, @RequestParam(value="param", required=true) String param, @RequestParam(value="baseUrl", required=true) String baseUrl) throws CollectorServiceException {
        return ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listValidValuesForParam(protocol, baseUrl, param, null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(HttpServletRequest req, Exception e) {
        log.error((Object)("Error processing " + req.getRequestURI()), (Throwable)e);
        return new ErrorMessage(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
    }
}

