function common_init($scope, $http, $sce, $location) {
	$scope.currentRepoId = '';
	$scope.currentRepoName = '';
	$scope.currentRepo = '';
	
	$scope.go = function(path) {
		$location.path(path); 
	}
	
	$scope.showError = function(error) {
		show_notification("error", error);
	}
	
	$scope.showNotification = function(message) {
		show_notification("info", message);
	}
	
	$scope.showSpinner = function() {
		showSpinner();
	}

	$scope.hideSpinner = function() {
		hideSpinner();
	}
	
	initSpinner();
	
	$scope.showDetails = function(id, name) {
		$scope.showSpinner();

		$http.get('getRepoDetails.do?id=' + id)
        .success(
            function(data) {
            	$scope.currentRepoId = id;
            	$scope.currentRepoName = name;
            	$scope.currentRepo = data;
            	$scope.hideSpinner();
            	$('#repoDetailsModal').modal('show');
            }
        ).error(
            function() {
            	$scope.showError('Something really bad must have happened to our fellow hamster..');
            	$scope.hideSpinner();
            }
        );
	}
	
	$scope.editDatasourceTickets = function(api) {
		
		var current = "";
		
		angular.forEach(api.tickets, function(t) {
			if (current) current += ', ';
			current += t.label.replace(/\D/g,'');
		});
		
		var newValue = prompt("Edit ticket numbers (integer, comma separeted)", current);
		
		if (newValue != null) {
			var list = [];

			angular.forEach(newValue.split(','), function(t) {
				var n = t.replace(/\D/g,'');
				if (n) {
					list.push(parseInt(n));
				}
			});
			
			$scope.showSpinner();
			$http.defaults.headers.post["Content-Type"] = "application/json;charset=UTF-8";
			$http.post('updateRepoTickets.do?id=' + api.repoId, list).success(function(data) {
				api.tickets = data;
				$scope.hideSpinner();
			}).error(function(err) {
				$scope.showError("Error updating tickets");
				$scope.hideSpinner();
			});
		}		
	}
	
	$scope.resizeMainElement = function(elem) {
		var height = 0;
		var body = window.document.body;
		if (window.innerHeight) {
			height = window.innerHeight;
		} else if (body.parentElement.clientHeight) {
			height = body.parentElement.clientHeight;
		} else if (body && body.clientHeight) {
			height = body.clientHeight;
		}
		elem.style.height = ((height - elem.offsetTop - 80) + "px");
	}

	
}