/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DnetParamValuesController
extends AbstractAjaxController {
    @Resource
    private List<ValidNodeValuesFetcher> validNodesFetchers;
    private static final Log log = LogFactory.getLog(DnetParamValuesController.class);

    @RequestMapping(value={"/ui/**/wf_obtainValidValues.list"})
    public void obtainValidValues(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="bean", required=true) String bean) throws IOException {
        ValidNodeValuesFetcher fetcher = this.findValidNodeValuesFetcher(bean);
        if (fetcher == null) {
            log.error((Object)("ValidNodeValuesFetcher not found: " + bean));
            this.sendResponse(response, new ArrayList<ValidNodeValuesFetcher.DnetParamValue>());
        } else {
            Map<String, String> params = this.findParams(request);
            this.sendResponse(response, fetcher.evaluate(params));
        }
    }

    private ValidNodeValuesFetcher findValidNodeValuesFetcher(String bean) {
        for (ValidNodeValuesFetcher fetcher : this.validNodesFetchers) {
            if (!fetcher.getName().equals(bean)) continue;
            return fetcher;
        }
        return null;
    }

    private Map<String, String> findParams(HttpServletRequest request) {
        HashMap params = Maps.newHashMap();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            params.put(name, request.getParameter(name));
        }
        return params;
    }

    private void sendResponse(HttpServletResponse response, List<ValidNodeValuesFetcher.DnetParamValue> values) throws IOException {
        Collections.sort(values);
        response.setContentType("application/json;charset=UTF-8");
        IOUtils.copy((Reader)new StringReader(new Gson().toJson(values)), (OutputStream)response.getOutputStream());
    }
}

