/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.gson.Gson;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ui.ModelMap;

public class WfEntryPointController
extends ModuleEntryPoint {
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private static final Log log = LogFactory.getLog(WfEntryPointController.class);
    private final Gson gson = new Gson();

    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameterMap().containsKey("wfId")) {
            this.initialize_direct_wf(map, request);
        } else {
            this.initialize_normal(map, request);
        }
    }

    private void initialize_direct_wf(ModelMap map, HttpServletRequest request) {
        String wfId = request.getParameter("wfId");
        StringWriter sw = new StringWriter();
        sw.append("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') ");
        sw.append("where $x//WORKFLOW/@id='");
        sw.append(wfId);
        sw.append("' return concat(");
        sw.append("$x//METAWORKFLOW_SECTION, ");
        sw.append("' |=@=| ', ");
        sw.append("$x//RESOURCE_IDENTIFIER/@value, ");
        sw.append("' |=@=| ', ");
        sw.append("$x//DATAPROVIDER/@id, ");
        sw.append("' |=@=| ', ");
        sw.append("$x//DATAPROVIDER/@interface)");
        try {
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(sw.toString());
            if (list.size() > 0) {
                String[] arr = ((String)list.get(0)).split("\\|=@=\\|");
                String section = arr[0].trim();
                String metaWf = arr[1].trim();
                String repoId = arr[2].trim();
                String repoApi = arr[3].trim();
                if (!(StringUtils.isEmpty((String)repoId) || StringUtils.isEmpty((String)repoApi) || StringUtils.isEmpty((String)metaWf) || StringUtils.isEmpty((String)wfId))) {
                    map.addAttribute("redirect", (Object)("repoApis.do#/api/" + URLEncoder.encode(repoId, "UTF-8") + "/" + URLEncoder.encode(repoApi, "UTF-8") + "/" + URLEncoder.encode(metaWf, "UTF-8") + "/" + URLEncoder.encode(wfId, "UTF-8")));
                } else {
                    map.addAttribute("initialWf", (Object)this.gson.toJson((Object)wfId));
                    map.addAttribute("initialMetaWf", (Object)this.gson.toJson((Object)metaWf));
                    map.addAttribute("section", (Object)this.gson.toJson((Object)section));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error obtaining details of wf " + wfId));
        }
    }

    private void initialize_normal(ModelMap map, HttpServletRequest request) {
        if (request.getParameterMap().containsKey("section")) {
            map.addAttribute("section", (Object)this.gson.toJson((Object)request.getParameter("section")));
        }
        if (request.getParameterMap().containsKey("metaWf")) {
            map.addAttribute("initialMetaWf", (Object)this.gson.toJson((Object)request.getParameter("metaWf")));
        }
    }
}

