/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.ProcessState;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AdvancedMetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AtomicWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeTokenInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeWithUserParams;
import eu.dnetlib.functionality.modular.ui.workflows.objects.ProcessListEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer.ProcessGraphGenerator;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISRegistryClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.sarasvati.loader.ProfileToSarasvatiConverter;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import eu.dnetlib.msro.workflows.sarasvati.registry.GraphProcessRegistry;
import eu.dnetlib.msro.workflows.util.ProcessUtils;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WorkflowsController
extends AbstractAjaxController {
    @Resource
    private ISLookupClient isLookupClient;
    @Resource
    private ISRegistryClient isRegistryClient;
    @Resource
    private GraphProcessRegistry graphProcessRegistry;
    @Resource
    private ProcessGraphGenerator processGraphGenerator;
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private ProfileToSarasvatiConverter profileToSarasvatiConverter;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    private static final Log log = LogFactory.getLog(WorkflowsController.class);

    @RequestMapping(value={"/ui/list_metaworkflows.json"})
    @ResponseBody
    public List<MetaWorkflowDescriptor> listMetaWorflowsForSection(@RequestParam(value="section", required=false) String sectionName, @RequestParam(value="dsId", required=false) String dsId) throws ISLookUpException, IOException {
        if (sectionName != null) {
            return this.workflowSectionGrouper.listMetaWorflowsForSection(sectionName);
        }
        if (dsId != null) {
            return this.workflowSectionGrouper.listMetaWorflowsForDatasource(dsId);
        }
        return Lists.newArrayList();
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.json"})
    @ResponseBody
    public AdvancedMetaWorkflowDescriptor getMetaWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        return this.isLookupClient.getMetaWorkflow(id);
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.json"})
    @ResponseBody
    public AtomicWorkflowDescriptor getAtomicWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        AtomicWorkflowDescriptor wf = this.isLookupClient.getAtomicWorkflow(id);
        String xml = this.profileToSarasvatiConverter.getSarasvatiWorkflow(id).getWorkflowXml();
        wf.setMapContent(this.processGraphGenerator.getWfDescImageMap(id, xml));
        return wf;
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.img"})
    public void showAtomicWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        String xml = this.profileToSarasvatiConverter.getSarasvatiWorkflow(id).getWorkflowXml();
        Set<String> notConfiguredNodes = this.isLookupClient.getNotConfiguredNodes(id);
        BufferedImage image = this.processGraphGenerator.getWfDescImage(id, xml, notConfiguredNodes);
        this.sendImage(response, image);
    }

    private void sendImage(HttpServletResponse response, BufferedImage image) throws IOException {
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "png", (OutputStream)out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/ui/wf.start"})
    @ResponseBody
    public String startWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        return this.workflowExecutor.startProcess(id);
    }

    @RequestMapping(value={"/ui/metawf.start"})
    @ResponseBody
    public String startMetaWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        this.workflowExecutor.startMetaWorkflow(id, true);
        return id;
    }

    @RequestMapping(value={"/ui/wf_workflow_node.json"})
    @ResponseBody
    public NodeInfo workflowNode_info(@RequestParam(value="wf", required=true) String wfId, @RequestParam(value="node", required=true) String nodeName) throws ISLookUpException, IOException {
        return this.isLookupClient.getNodeInfo(wfId, nodeName);
    }

    @RequestMapping(value={"/ui/wf_metaworkflow.edit"})
    @ResponseBody
    public boolean scheduleMetaWorkflow(@RequestParam(value="json", required=true) String json) throws Exception {
        AdvancedMetaWorkflowDescriptor info = (AdvancedMetaWorkflowDescriptor)new Gson().fromJson(json, AdvancedMetaWorkflowDescriptor.class);
        log.info((Object)("Updating workflow " + info.getName()));
        String xml = this.isLookupClient.getProfile(info.getWfId());
        boolean res = this.isRegistryClient.updateSarasvatiMetaWorkflow(info.getWfId(), xml, info);
        return res;
    }

    @RequestMapping(value={"/ui/clone_metaworkflow.do"})
    @ResponseBody
    public String cloneMetaWf(@RequestParam(value="id", required=true) String id, @RequestParam(value="name", required=true) String name) throws Exception {
        if (name.trim().length() > 0) {
            String xml = this.isLookupClient.getProfile(id);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(xml));
            doc.selectSingleNode("//METAWORKFLOW_NAME").setText(name);
            for (Object o : doc.selectNodes("//WORKFLOW")) {
                Element n = (Element)o;
                String atomWfXml = this.isLookupClient.getProfile(n.valueOf("@id"));
                String newAtomWfId = this.isRegistryClient.registerProfile(atomWfXml);
                n.addAttribute("id", newAtomWfId);
            }
            return this.isRegistryClient.registerProfile(doc.asXML());
        }
        throw new IllegalArgumentException("Name is empty");
    }

    @RequestMapping(value={"/ui/wf_proc_node.json"})
    @ResponseBody
    public NodeTokenInfo getProcessWorkflowNode(@RequestParam(value="id", required=true) String pid, @RequestParam(value="node", required=true) long nid) throws Exception {
        NodeToken token = this.findNodeToken(pid, nid);
        NodeTokenInfo info = token == null ? new NodeTokenInfo(this.findNodeName(pid, nid)) : new NodeTokenInfo(token);
        return info;
    }

    private NodeToken findNodeToken(String pid, long nid) {
        GraphProcess process = this.graphProcessRegistry.findProcess(pid);
        if (process != null) {
            for (NodeToken token : process.getNodeTokens()) {
                if (token.getNode().getId() != nid) continue;
                return token;
            }
        }
        return null;
    }

    private String findNodeName(String pid, long nid) {
        GraphProcess process = this.graphProcessRegistry.findProcess(pid);
        if (process != null) {
            for (Node node : process.getGraph().getNodes()) {
                if (node.getId() != nid) continue;
                return node.getName();
            }
        }
        return "-";
    }

    @RequestMapping(value={"/ui/wf_proc.img"})
    public void showProcessWorkflow(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        BufferedImage image = this.processGraphGenerator.getProcessImage(id);
        this.sendImage(response, image);
    }

    @RequestMapping(value={"/ui/wf_proc.kill"})
    @ResponseBody
    public boolean killProcessWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        GraphProcess proc = this.graphProcessRegistry.findProcess(id);
        proc.setState(ProcessState.Canceled);
        return true;
    }

    @RequestMapping(value={"/ui/wf_journal.range"})
    @ResponseBody
    public Collection<ProcessListEntry> rangeWfJournal(@RequestParam(value="start", required=true) String start, @RequestParam(value="end", required=true) String end) throws Exception {
        HashMap res = Maps.newHashMap();
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTime startDate = formatter.parseDateTime(start);
        DateTime endDate = formatter.parseDateTime(end).plusHours(23).plusMinutes(59).plusSeconds(59);
        Iterator iter = Iterators.transform((Iterator)this.dnetLogger.range(startDate.toDate(), endDate.toDate()), (Function)new JournalEntryFunction());
        while (iter.hasNext()) {
            ProcessListEntry e = (ProcessListEntry)iter.next();
            res.put(e.getProcId(), e);
        }
        long now = DateUtils.now();
        if (startDate.isBefore(now) && endDate.isAfter(now)) {
            for (String pid : this.graphProcessRegistry.listIdentifiers()) {
                GraphProcess proc = this.graphProcessRegistry.findProcess(pid);
                res.put(pid, new ProcessListEntry(pid, proc));
            }
        }
        return res.values();
    }

    @RequestMapping(value={"/ui/wf_journal.find"})
    @ResponseBody
    public Collection<ProcessListEntry> findWfJournal(@RequestParam(value="wfs", required=true) String wfs) {
        HashMap res = Maps.newHashMap();
        Set wfFilter = (Set)new Gson().fromJson(wfs, new TypeToken<Set<String>>(){}.getType());
        for (String wfId : wfFilter) {
            Iterator iter = Iterators.transform((Iterator)this.dnetLogger.find("system:profileId", wfId), (Function)new JournalEntryFunction());
            while (iter.hasNext()) {
                ProcessListEntry e = (ProcessListEntry)iter.next();
                res.put(e.getProcId(), e);
            }
        }
        for (String pid : this.graphProcessRegistry.listIdentifiers()) {
            GraphProcess proc = this.graphProcessRegistry.findProcess(pid);
            if (!wfFilter.contains(ProcessUtils.calculateWfId((GraphProcess)proc))) continue;
            res.put(pid, new ProcessListEntry(pid, proc));
        }
        return res.values();
    }

    @RequestMapping(value={"/ui/wf_journal_byFamily.find"})
    @ResponseBody
    public Collection<ProcessListEntry> findWfJournalByFamily(@RequestParam(value="family", required=true) String family) throws IOException {
        Iterator iter = Iterators.transform((Iterator)this.dnetLogger.find("system:profileFamily", family), (Function)new JournalEntryFunction());
        return Lists.newArrayList((Iterator)iter);
    }

    @RequestMapping(value={"/ui/wf_journal.get"})
    @ResponseBody
    public Map<String, Object> getWfJournalLog(@RequestParam(value="id", required=true) String id) throws Exception {
        GraphProcess process;
        HashMap res = Maps.newHashMap();
        Map logs = this.dnetLogger.findOne("system:processId", id);
        if (logs != null && !logs.isEmpty()) {
            ArrayList keys = Lists.newArrayList(logs.keySet());
            Collections.sort(keys);
            ArrayList journalEntry = Lists.newArrayList();
            for (String k : keys) {
                HashMap m = Maps.newHashMap();
                m.put("name", k);
                m.put("value", logs.get(k));
                journalEntry.add(m);
            }
            res.put("journal", journalEntry);
        }
        if ((process = this.graphProcessRegistry.findProcess(id)) != null) {
            String mapContent = process.getState() == ProcessState.Created ? "" : this.processGraphGenerator.getProcessImageMap(id);
            String status = "";
            status = !process.isComplete() ? process.getState().toString().toUpperCase() : ("true".equals(process.getEnv().getAttribute("system:isCompletedSuccessfully")) ? "SUCCESS" : "FAILURE");
            String img = process.getState() == ProcessState.Created ? "../resources/img/notStarted.gif" : "wf_proc.img?id=" + id + "&t=" + DateUtils.now();
            String name = process.getGraph().getName();
            long startDate = NumberUtils.toLong((String)process.getEnv().getAttribute("system:startDate"), (long)0L);
            long endDate = NumberUtils.toLong((String)process.getEnv().getAttribute("system:endDate"), (long)0L);
            AtomicWorkflowDescriptor wf = new AtomicWorkflowDescriptor(id, name, status, mapContent, img, true, "auto", "RUNNING", startDate, endDate);
            res.put("graph", wf);
        }
        return res;
    }

    @RequestMapping(value={"/ui/wf_atomic_workflow.enable"})
    @ResponseBody
    public String enableAtomicWf(@RequestParam(value="id", required=true) String id, @RequestParam(value="start", required=true) String value) throws Exception {
        this.isRegistryClient.configureWorkflowStart(id, value);
        return value;
    }

    @RequestMapping(value={"/ui/workflow_user_params.json"})
    @ResponseBody
    public List<NodeWithUserParams> listWorkflowUserParams(@RequestParam(value="wf", required=true) String wfId) throws Exception {
        return this.isLookupClient.listWorkflowUserParams(wfId);
    }

    @RequestMapping(value={"/ui/save_user_params.do"})
    @ResponseBody
    public boolean saveWorkflowUserParams(@RequestParam(value="wf", required=true) String wfId, @RequestParam(value="params", required=true) String jsonParams) throws Exception {
        String xml = this.isLookupClient.getProfile(wfId);
        List params = (List)new Gson().fromJson(jsonParams, new TypeToken<List<NodeWithUserParams>>(){}.getType());
        boolean res = this.isRegistryClient.updateSarasvatiWorkflow(wfId, xml, params);
        for (String metaWfId : this.isLookupClient.listMetaWorflowsForWfId(wfId)) {
            if (this.isLookupClient.isExecutable(metaWfId)) {
                this.isRegistryClient.updateMetaWorkflowStatus(metaWfId, WorkflowsConstants.WorkflowStatus.EXECUTABLE);
                continue;
            }
            this.isRegistryClient.updateMetaWorkflowStatus(metaWfId, WorkflowsConstants.WorkflowStatus.WAIT_USER_SETTINGS);
        }
        return res;
    }

    private final class JournalEntryFunction
    implements Function<Map<String, String>, ProcessListEntry> {
        private JournalEntryFunction() {
        }

        public ProcessListEntry apply(Map<String, String> input) {
            String name = input.get("system:profileName");
            String repo = input.containsKey("dataprovider:name") ? input.get("dataprovider:name") : "";
            String repoId = input.containsKey("dataprovider:originalid") ? input.get("dataprovider:originalid") : "";
            String apiId = input.containsKey("dataprovider:interface") ? input.get("dataprovider:interface") : "";
            String procId = input.get("system:processId");
            String wfId = input.get("system:profileId");
            String family = input.get("system:profileFamily");
            long date = NumberUtils.toLong((String)input.get("log:date"), (long)0L);
            String status = Boolean.valueOf(input.get("system:isCompletedSuccessfully")) != false ? "SUCCESS" : "FAILURE";
            return new ProcessListEntry(procId, wfId, name, family, status, date, repo, repoId, apiId);
        }
    }
}

