/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.common.NodeDrawConfig;
import com.googlecode.sarasvati.visual.util.FontUtil;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.AbstractIcon;
import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class GraphIcon
extends AbstractIcon {
    private Color bgColor;

    public GraphIcon(Node node, NodeStatus status) {
        super(node);
        switch (status) {
            case CONFIGURED: {
                this.bgColor = Color.decode("#0088cc");
                break;
            }
            case NOT_CONFIGURED: {
                this.bgColor = Color.decode("#dd8800");
                break;
            }
            case SYSTEM: {
                this.bgColor = Color.decode("#9999dd");
                break;
            }
            default: {
                this.bgColor = Color.decode("#aabbcc");
            }
        }
        this.redrawImage();
    }

    public void redrawImage(Graphics2D gfx) {
        int padding;
        super.resetGfx(gfx);
        gfx.setColor(this.bgColor);
        gfx.fillOval(0, 0, 99, HEIGHT - 1);
        gfx.setColor(NodeDrawConfig.NODE_BORDER);
        int offset = 1;
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, this.getDashes(), 0.0f);
        gfx.setStroke(stroke);
        int width = 100 - ((offset << 1) + 1);
        int height = HEIGHT - ((offset << 1) + 1);
        gfx.drawOval(offset, offset, width, height);
        gfx.setColor(Color.white);
        int startX = padding = 2 + (offset += 3);
        int maxWidth = this.getIconWidth() - (padding << 1);
        FontUtil.setSizedFont((Graphics)gfx, (String)this.getLabel(), (float)10.0f, (int)maxWidth);
        int strWidth = (int)Math.ceil(gfx.getFontMetrics().getStringBounds(this.getLabel(), gfx).getWidth());
        int strHeight = gfx.getFontMetrics().getAscent();
        int left = startX + (maxWidth - strWidth >> 1);
        int top = this.getIconHeight() + strHeight >> 1;
        gfx.drawString(this.getLabel(), left, top);
        super.resetGfx(gfx);
    }
}

