/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.GraphToImageMapAdapter;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.GraphIcon;
import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import java.util.Set;
import javax.swing.Icon;

public class GraphToImageMapHelper
extends GraphToImageMapAdapter {
    private String workflowId;
    private Set<String> notConfiguredNodes;

    public GraphToImageMapHelper(String workflowId, Set<String> notConfiguredNodes) {
        this.workflowId = workflowId;
        this.notConfiguredNodes = notConfiguredNodes;
    }

    public String hrefForNode(Node node) {
        if (this.workflowId == null || this.workflowId.isEmpty()) {
            return "javascript:alert('TODO')";
        }
        if (node.getName().equals("success") || node.getName().equals("failure")) {
            return "javascript:void(0)";
        }
        return "javascript:getScope('map').getNodeDetails('" + this.workflowId + "', '" + node.getName() + "')";
    }

    public String hoverForNode(Node node) {
        return "Name: " + node.getName();
    }

    public Icon iconForNode(Node node) {
        if (node.getName().equals("success") || node.getName().equals("failure")) {
            return new GraphIcon(node, NodeStatus.SYSTEM);
        }
        if (this.notConfiguredNodes != null && this.notConfiguredNodes.contains(node.getName())) {
            return new GraphIcon(node, NodeStatus.NOT_CONFIGURED);
        }
        return new GraphIcon(node, NodeStatus.CONFIGURED);
    }
}

