/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.viewer;

import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.ProcessToImageMapAdapter;
import com.googlecode.sarasvati.visual.process.VisualProcessNode;
import eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons.ProcessJobIcon;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessToImageMapHelper
extends ProcessToImageMapAdapter {
    private String procId;
    private static final Log log = LogFactory.getLog(ProcessToImageMapHelper.class);

    public ProcessToImageMapHelper(String procId) {
        this.procId = procId;
    }

    public String hrefForNode(VisualProcessNode node) {
        return "javascript:getScope('map').getProcessNodeDetails('" + this.procId + "', '" + node.getNode().getId() + "')";
    }

    public String hoverForNode(VisualProcessNode vnode) {
        Node node = vnode.getNode();
        if (node instanceof ProgressJobNode) {
            try {
                ProgressProvider progress = ((ProgressJobNode)node).getProgressProvider();
                if (progress == null) {
                    return "Processed: -";
                }
                if (progress.isInaccurate()) {
                    return "Processed: " + progress.getCurrentValue();
                }
                return "Processed: " + progress.getCurrentValue() + " - Total: " + progress.getTotalValue();
            }
            catch (Throwable e) {
                log.warn((Object)"Error obtainig provider info", e);
                return e.getMessage();
            }
        }
        return "Name: " + node.getName();
    }

    public Icon iconForNode(VisualProcessNode vnode) {
        Node node = vnode.getNode();
        ProgressProvider progressProvider = node instanceof ProgressJobNode ? ((ProgressJobNode)node).getProgressProvider() : null;
        return new ProcessJobIcon(node, vnode.getToken(), progressProvider);
    }
}

