/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AdvancedMetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.AtomicWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.MetaWorkflowDescriptor;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.NodeWithUserParams;
import eu.dnetlib.functionality.modular.ui.workflows.util.functions.NodeToWorkflowParam;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.nodes.NodeStatus;
import eu.dnetlib.msro.workflows.util.WorkflowParam;
import eu.dnetlib.msro.workflows.util.WorkflowParamUI;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class ISLookupClient {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private static final Log log = LogFactory.getLog(ISLookupClient.class);
    private static final ApplyXslt metaWorkflowToHTML = new ApplyXslt((Source)new StreamSource(ISLookupClient.class.getResourceAsStream("/eu/dnetlib/functionality/modular/workflows/xslt/metawf_profile2html.xslt")));
    private String categoryUisJson;
    private Map<String, List<WorkflowParamUI>> categoryUis;

    @PostConstruct
    private void init() {
        log.info((Object)("Initialing categoryUis map using JSON: " + this.getCategoryUisJson()));
        this.categoryUis = (Map)new Gson().fromJson(this.getCategoryUisJson(), new TypeToken<Map<String, List<WorkflowParamUI>>>(){}.getType());
    }

    public List<String> listSimpleWorflowSections() {
        String xquery = "distinct-values(//METAWORKFLOW_SECTION/text())";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("distinct-values(//METAWORKFLOW_SECTION/text())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error obtaining worflowSections", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<MetaWorkflowDescriptor> listMetaWorflowsForSection(String name) {
        return this.listMetaWorflowsByCondition(".//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//METAWORKFLOW_SECTION='" + name + "'");
    }

    public List<MetaWorkflowDescriptor> listMetaWorflowsForDatasource(String dsId) {
        return this.listMetaWorflowsByCondition(".//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//DATAPROVIDER/@id='" + dsId + "'");
    }

    private List<MetaWorkflowDescriptor> listMetaWorflowsByCondition(String cond) {
        String query = "for $x in /*[" + cond + "] order by $x//METAWORKFLOW_NAME return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//METAWORKFLOW_NAME, ' @@@ ', $x//METAWORKFLOW_NAME/@family, ' @@@ ', $x//CONFIGURATION/@status)";
        try {
            return Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query), (Function)new Function<String, MetaWorkflowDescriptor>(){

                public MetaWorkflowDescriptor apply(String s) {
                    Iterator iter = Splitter.on((String)"@@@").trimResults().split((CharSequence)s).iterator();
                    String id = (String)iter.next();
                    String name = (String)iter.next();
                    String family = (String)iter.next();
                    WorkflowsConstants.WorkflowStatus status = WorkflowsConstants.WorkflowStatus.valueOf((String)((String)iter.next()));
                    return new MetaWorkflowDescriptor(id, name, status, family);
                }
            });
        }
        catch (ISLookUpException e) {
            return Lists.newArrayList();
        }
    }

    public AtomicWorkflowDescriptor getAtomicWorkflow(String id) {
        String xml = this.getProfile(id);
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(xml));
            String name = doc.valueOf("//WORKFLOW_NAME");
            String imageUrl = "wf_atomic_workflow.img?id=" + id + "&t=" + DateUtils.now();
            String lastExecutionDate = doc.valueOf("//STATUS/LAST_EXECUTION_DATE");
            String start = doc.valueOf("//CONFIGURATION/@start");
            boolean ready = doc.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty();
            return new AtomicWorkflowDescriptor(id, name, "", null, imageUrl, ready, start, lastExecutionDate, 0L, 0L);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
            return new AtomicWorkflowDescriptor("", "", "", null, "", false, "disabled", "", 0L, 0L);
        }
    }

    public String getProfile(String id) {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(id);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error finding profile: " + id), (Throwable)e);
            return null;
        }
    }

    public NodeInfo getNodeInfo(String wfId, String nodeName) {
        try {
            String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + wfId + "']//NODE[@name='" + nodeName + "']";
            String xml = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(xml));
            String name = doc.valueOf("/NODE/@name");
            String desc = doc.valueOf("//DESCRIPTION");
            List params = Lists.transform((List)doc.selectNodes("//PARAM"), (Function)new NodeToWorkflowParam(this.getCategoryUis()));
            return new NodeInfo(name, desc, params);
        }
        catch (Exception e) {
            log.error((Object)("Error accessing node " + nodeName + " of wf " + wfId), (Throwable)e);
            return new NodeInfo("", "", new ArrayList<WorkflowParam>());
        }
    }

    public Set<String> getNotConfiguredNodes(String id) {
        String query = "for $x in (/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//NODE) where count($x//PARAM[@required='true' and string-length(normalize-space(.)) = 0]) > 0 return $x/@name/string()";
        try {
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
            return Sets.newHashSet((Iterable)list);
        }
        catch (Exception e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public AdvancedMetaWorkflowDescriptor getMetaWorkflow(String id) {
        String xml = this.getProfile(id);
        HashSet innerWfs = Sets.newHashSet();
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(xml));
            String name = doc.valueOf("//METAWORKFLOW_NAME");
            String family = doc.valueOf("//METAWORKFLOW_NAME/@family");
            String email = doc.valueOf("//ADMIN_EMAIL");
            boolean scheduled = Boolean.valueOf(doc.valueOf("//SCHEDULING/@enabled"));
            String cronExpression = doc.valueOf("//SCHEDULING/CRON");
            int minInterval = Integer.parseInt(doc.valueOf("//SCHEDULING/MININTERVAL"));
            WorkflowsConstants.WorkflowStatus status = WorkflowsConstants.WorkflowStatus.valueOf((String)doc.valueOf("//CONFIGURATION/@status"));
            for (Object o : doc.selectNodes("//WORKFLOW")) {
                Element wf = (Element)o;
                String wfId = wf.valueOf("@id");
                innerWfs.add(wfId);
                try {
                    String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(wfId);
                    Document doc2 = new SAXReader().read((Reader)new StringReader(profile));
                    String start = doc2.valueOf("//CONFIGURATION/@start");
                    String lastDate = doc2.valueOf("//STATUS/LAST_EXECUTION_DATE");
                    String lastStatus = doc2.valueOf("//STATUS/LAST_EXECUTION_STATUS");
                    wf.addAttribute("start", start);
                    if (!StringUtils.isEmpty((String)lastDate)) {
                        wf.addAttribute("date", lastDate);
                    }
                    if (!StringUtils.isEmpty((String)lastStatus)) {
                        wf.addAttribute("status", lastStatus);
                    }
                    if ("disabled".equalsIgnoreCase(start)) {
                        wf.addAttribute("disabled", "true");
                    }
                    if (doc2.selectNodes("//PARAM[@required='true' and string-length(normalize-space(.)) = 0]").isEmpty()) {
                        wf.addAttribute("configured", "true");
                        continue;
                    }
                    wf.addAttribute("configured", "false");
                }
                catch (Exception e) {
                    log.error((Object)"Error obtaining wf status", (Throwable)e);
                    wf.addAttribute("status", NodeStatus.NOT_CONFIGURED.toString());
                }
            }
            ApplyXslt metaWorkflowToHTML = new ApplyXslt((Source)new StreamSource(ISLookupClient.class.getResourceAsStream("/eu/dnetlib/functionality/modular/workflows/xslt/metawf_profile2html.xslt")));
            String html = metaWorkflowToHTML.evaluate((Object)doc.asXML());
            return new AdvancedMetaWorkflowDescriptor(id, name, email, scheduled, cronExpression, minInterval, status, family, innerWfs, html);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing xml: " + xml), (Throwable)e);
            return new AdvancedMetaWorkflowDescriptor("", "", "", false, "", 0, WorkflowsConstants.WorkflowStatus.MISSING, "", new HashSet<String>(), "");
        }
    }

    public Map<String, String> listRepoHiWorkflows() {
        HashMap map = Maps.newHashMap();
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)";
        try {
            for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)")) {
                String[] arr = s.split("@@@");
                map.put(arr[0].trim(), arr[1].trim());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing xquery: for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//WORKFLOW_NAME)", (Throwable)e);
        }
        return map;
    }

    public List<String> listMetaWorflowsForWfId(String wfId) {
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where $x//WORKFLOW/@id='" + wfId + "' return $x//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public boolean isExecutable(String metaWfId) {
        String query = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')[.//RESOURCE_IDENTIFIER/@value = '" + metaWfId + "']//WORKFLOW/@id \nfor $y in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType')[.//RESOURCE_IDENTIFIER/@value = $x]//PARAM[@required='true' and string-length(normalize-space(.)) = 0] \nreturn $y";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query).isEmpty();
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return false;
        }
    }

    public List<String> listWfFamilies() {
        String query = "distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error executing xquery: distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where string-length($x//DATAPROVIDER/@id) > 0 return $x//METAWORKFLOW_NAME/@family/string())", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public String getDatasourceName(String dsId) {
        String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//OFFICIAL_NAME/text()";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error executing xquery: " + query), (Throwable)e);
            return "UNKNOWN";
        }
    }

    public List<NodeWithUserParams> listWorkflowUserParams(String wfId) {
        ArrayList res = Lists.newArrayList();
        String xml = this.getProfile(wfId);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(xml));
            for (Object o : doc.selectNodes("//NODE")) {
                Element node = (Element)o;
                List pnodes = node.selectNodes(".//PARAM[@managedBy='user' or @category]");
                if (pnodes.size() <= 0) continue;
                String name = node.valueOf("@name");
                String desc = node.valueOf("./DESCRIPTION");
                List params = Lists.transform((List)pnodes, (Function)new NodeToWorkflowParam(this.getCategoryUis()));
                res.add(new NodeWithUserParams(name, desc, params));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error obtaing params of wf: " + wfId), (Throwable)e);
        }
        return res;
    }

    public Map<String, List<WorkflowParamUI>> getCategoryUis() {
        return this.categoryUis;
    }

    public String getCategoryUisJson() {
        return this.categoryUisJson;
    }

    @Required
    public void setCategoryUisJson(String categoryUisJson) {
        this.categoryUisJson = categoryUisJson;
    }
}

