/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.util.functions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.msro.workflows.util.WorkflowParam;
import eu.dnetlib.msro.workflows.util.WorkflowParamUI;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;

public class NodeToWorkflowParam
implements Function<Node, WorkflowParam> {
    private Map<String, List<WorkflowParamUI>> mapUis = Maps.newHashMap();

    public NodeToWorkflowParam(Map<String, List<WorkflowParamUI>> mapUis) {
        this.mapUis = mapUis;
    }

    public WorkflowParam apply(Node n) {
        String key = n.valueOf("@name");
        boolean required = "true".equalsIgnoreCase(n.valueOf("@required"));
        String type = n.valueOf("@type");
        String function = n.valueOf("@function");
        String value = n.getText();
        boolean userParam = "user".equals(n.valueOf("@managedBy"));
        String category = n.valueOf("@category");
        List<WorkflowParamUI> uis = this.calculateUis(category);
        return new WorkflowParam(key, value, required, userParam, type, function, uis);
    }

    private List<WorkflowParamUI> calculateUis(String category) {
        if (!StringUtils.isEmpty((String)category) && this.mapUis.containsKey(category)) {
            return this.mapUis.get(category);
        }
        return Lists.newArrayList();
    }
}

