package eu.dnetlib.msro.workflows.nodes;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.lang.reflect.Type;
import java.util.Map;

/**
 * This job node receives a json encoded map declaring a set of key value paris. Each pair represents
 * a tuple [parameter name - parameter value] to be set in the workflow environment.
 */
public class SetEnvJsonParametersJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(SetEnvJsonParametersJobNode.class);

	private static Type mapType = new TypeToken<Map<String, String>>() {}.getType();

	private String json;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final Map<String, String> params = new Gson().fromJson(getJson(), mapType);

		params.forEach((k, v) -> {
			log.info(String.format("set env parameter: '%s':'%s'", k, v));
			token.getEnv().setAttribute(k, v);
		});

		return Arc.DEFAULT_ARC;
	}

	public String getJson() {
		return json;
	}

	public void setJson(final String json) {
		this.json = json;
	}

}
