/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.common.logging.LogMessage;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SuccessFailureNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SuccessFailureNode.class);
    private boolean success;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;

    @Override
    protected String execute(NodeToken token) {
        String profileId = token.getFullEnv().getAttribute("system:profileId").trim();
        long now = DateUtils.now();
        String date = DateUtils.calculate_ISO8601((long)now);
        token.getProcess().getEnv().setAttribute("system:endDate", (Object)now);
        token.getProcess().getEnv().setAttribute("system:endHumanDate", date);
        Map<String, String> params = this.mergeEnvAttributes(token);
        LogMessage logMessage = this.dnetLogger.newLogMessage().addDetails(params);
        try {
            String template = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/eu/dnetlib/msro/workflows/templates/workflow_status.xml.st"));
            StringTemplate st = new StringTemplate(template);
            st.setAttribute("procId", (Object)StringEscapeUtils.escapeXml((String)params.get("system:processId")));
            st.setAttribute("date", (Object)StringEscapeUtils.escapeXml((String)date));
            st.setAttribute("params", this.filterOutputParams(params));
            if (!this.isSuccess()) {
                st.setAttribute("error", (Object)this.escape(params.get("system:error")));
            }
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(profileId, "//STATUS", st.toString());
            token.getProcess().getEnv().setAttribute("system:isCompletedSuccessfully", (Object)this.isSuccess());
            logMessage.addDetail("system:isCompletedSuccessfully", Boolean.toString(this.isSuccess()));
        }
        catch (Exception e) {
            log.error((Object)("Error updating workflow profile: " + profileId), (Throwable)e);
            token.getProcess().getEnv().setAttribute("system:isCompletedSuccessfully", (Object)false);
            logMessage.addDetail("system:isCompletedSuccessfully", Boolean.toString(false));
        }
        logMessage.flush();
        return Arc.DEFAULT_ARC;
    }

    private Map<String, String> filterOutputParams(Map<String, String> map) {
        HashMap res = Maps.newHashMap();
        if (map != null) {
            for (String k : map.keySet()) {
                if (StringUtils.isBlank((String)k) || !k.startsWith("dataprovider:") && !k.startsWith("mainlog:")) continue;
                String key = this.escape(k);
                String v = map.get(k);
                res.put(key, v != null ? this.escapeAttribute(this.escape(v)) : "null");
            }
        }
        return res;
    }

    private String escapeAttribute(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("\\{", "{{").replaceAll("\\}", "}}");
    }

    private Map<String, String> mergeEnvAttributes(NodeToken token) {
        HashMap map = Maps.newHashMap();
        for (String s : token.getEnv().getAttributeNames()) {
            map.put(s, token.getEnv().getAttribute(s));
        }
        for (String s : token.getFullEnv().getAttributeNames()) {
            map.put(s, token.getFullEnv().getAttribute(s));
        }
        return map;
    }

    protected String escape(String value) {
        return StringUtils.isNotBlank((String)value) ? StringEscapeUtils.escapeXml((String)value).replaceAll("\\{", "-").replaceAll("}", "-") : "";
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Required
    public void setSuccess(boolean success) {
        this.success = success;
    }
}

