package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SyncOAIStoreJobNode extends AbstractOAIJobNode implements ProgressJobNode {

	private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private ProcessCountingResultSetFactory processCountingResultSetFactory;
	
	private ResultsetProgressProvider progressProvider;

	private String eprParam;
	private boolean alwaysNewRecord = false;
	private boolean skipDuplicates = false;
	private String duplicateXPath;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {

		final String eprS = token.getEnv().getAttribute(getEprParam());
		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
		job.setAction("SYNC");
		job.getParameters().put(OAIParameterNames.OAI_FEED_DATE, DateUtils.now_ISO8601());
		job.getParameters().put(OAIParameterNames.OAI_SKIP_DUPLICATES, String.valueOf(skipDuplicates));
		if(skipDuplicates) job.getParameters().put(OAIParameterNames.OAI_DUPLICATE_XPATH, duplicateXPath);
		job.getParameters().put(OAIParameterNames.OAI_SYNC_EPR, progressProvider.getEpr().toString());
		job.getParameters().put(OAIParameterNames.OAI_ALWAYS_NEW_RECORD, String.valueOf(alwaysNewRecord));
		log.fatal("OAI Sync Job prepared");
	}

	public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
		return processCountingResultSetFactory;
	}

	@Required
	public void setProcessCountingResultSetFactory(final ProcessCountingResultSetFactory processCountingResultSetFactory) {
		this.processCountingResultSetFactory = processCountingResultSetFactory;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return this.progressProvider;
	}


	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public boolean isAlwaysNewRecord() {
		return alwaysNewRecord;
	}

	public void setAlwaysNewRecord(boolean alwaysNewRecord) {
		this.alwaysNewRecord = alwaysNewRecord;
	}

	public boolean isSkipDuplicates() {
		return skipDuplicates;
	}

	public void setSkipDuplicates(final boolean skipDuplicates) {
		this.skipDuplicates = skipDuplicates;
	}

	public String getDuplicateXPath() {
		return duplicateXPath;
	}

	public void setDuplicateXPath(final String duplicateXPath) {
		this.duplicateXPath = duplicateXPath;
	}

}
