/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.oai.workflows.nodes.AbstractOAIJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SyncOAIStoreJobNode
extends AbstractOAIJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(SyncOAIStoreJobNode.class);
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;
    private String eprParam;
    private boolean alwaysNewRecord = false;
    private boolean skipDuplicates = false;
    private String duplicateXPath;

    @Override
    void completePrepareJob(BlackboardJob job, NodeToken token) throws ResultSetException {
        String eprS = token.getEnv().getAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
        job.setAction("SYNC");
        job.getParameters().put(OAIParameterNames.OAI_FEED_DATE, DateUtils.now_ISO8601());
        job.getParameters().put(OAIParameterNames.OAI_SKIP_DUPLICATES, String.valueOf(this.skipDuplicates));
        if (this.skipDuplicates) {
            job.getParameters().put(OAIParameterNames.OAI_DUPLICATE_XPATH, this.duplicateXPath);
        }
        job.getParameters().put(OAIParameterNames.OAI_SYNC_EPR, this.progressProvider.getEpr().toString());
        job.getParameters().put(OAIParameterNames.OAI_ALWAYS_NEW_RECORD, String.valueOf(this.alwaysNewRecord));
        log.fatal((Object)"OAI Sync Job prepared");
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String getDuplicateXPath() {
        return this.duplicateXPath;
    }

    public void setDuplicateXPath(String duplicateXPath) {
        this.duplicateXPath = duplicateXPath;
    }
}

