/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.bulktag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.Community;
import eu.dnetlib.data.bulktag.Datasource;
import eu.dnetlib.data.bulktag.Pair;
import eu.dnetlib.data.bulktag.SelectionCriteria;
import eu.dnetlib.data.bulktag.ZenodoCommunity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommunityConfiguration {
    private static final Log log = LogFactory.getLog(CommunityConfiguration.class);
    private Map<String, Community> communities;
    private transient Map<String, List<Pair<String, SelectionCriteria>>> subjectMap = new HashMap<String, List<Pair<String, SelectionCriteria>>>();
    private transient Map<String, List<Pair<String, SelectionCriteria>>> datasourceMap = new HashMap<String, List<Pair<String, SelectionCriteria>>>();
    private transient Map<String, List<Pair<String, SelectionCriteria>>> zenodocommunityMap = new HashMap<String, List<Pair<String, SelectionCriteria>>>();

    public CommunityConfiguration(Map<String, Community> communities) {
        this.communities = communities;
        this.init();
    }

    public void init() {
        if (this.subjectMap == null) {
            this.subjectMap = Maps.newHashMap();
        }
        if (this.datasourceMap == null) {
            this.datasourceMap = Maps.newHashMap();
        }
        if (this.zenodocommunityMap == null) {
            this.zenodocommunityMap = Maps.newHashMap();
        }
        for (Community c : this.getCommunities().values()) {
            String id = c.getId();
            for (String sbj : c.getSubjects()) {
                Pair<String, SelectionCriteria> p = new Pair<String, SelectionCriteria>(id, new SelectionCriteria(null));
                this.add(sbj.toLowerCase().trim(), p, this.subjectMap);
            }
            for (Datasource d : c.getDatasources()) {
                this.add(d.getOpenaireId(), new Pair<String, SelectionCriteria>(id, d.getSelCriteria()), this.datasourceMap);
            }
            for (ZenodoCommunity zc : c.getZenodoCommunities()) {
                this.add(zc.getZenodoCommunityId(), new Pair<String, SelectionCriteria>(id, zc.getSelCriteria()), this.zenodocommunityMap);
            }
        }
    }

    private void add(String key, Pair<String, SelectionCriteria> value, Map<String, List<Pair<String, SelectionCriteria>>> map) {
        List<Pair<String, SelectionCriteria>> values = map.get(key);
        if (values == null) {
            values = new ArrayList<Pair<String, SelectionCriteria>>();
            map.put(key, values);
        }
        values.add(value);
    }

    public List<Pair<String, SelectionCriteria>> getCommunityForSubject(String sbj) {
        return this.subjectMap.get(sbj);
    }

    public List<Pair<String, SelectionCriteria>> getCommunityForDatasource(String dts) {
        return this.datasourceMap.get(dts);
    }

    public List<Pair<String, SelectionCriteria>> getCommunityForZenodoCommunity(String zc) {
        return this.zenodocommunityMap.get(zc);
    }

    public List<String> getCommunityForSubjectValue(String value) {
        return this.getContextIds(this.subjectMap.get(value));
    }

    public List<String> getCommunityForDatasourceValue(String value) {
        return this.getContextIds(this.datasourceMap.get(value.toLowerCase()));
    }

    public List<String> getCommunityForZenodoCommunityValue(String value) {
        return this.getContextIds(this.zenodocommunityMap.get(value.toLowerCase()));
    }

    private List<String> getContextIds(List<Pair<String, SelectionCriteria>> list) {
        if (list != null) {
            return list.stream().map(p -> (String)p.getFst()).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public Map<String, Community> getCommunities() {
        return this.communities;
    }

    public void setCommunities(Map<String, Community> communities) {
        this.communities = communities;
    }

    public String toJson() {
        Gson g = new Gson();
        return g.toJson((Object)this);
    }

    public int size() {
        return this.communities.keySet().size();
    }

    public Community getCommunityById(String id) {
        return this.communities.get(id);
    }

    public List<Community> getCommunityList() {
        return Lists.newLinkedList(this.communities.values());
    }

    static enum MapModes {
        SUBJECT_MAP,
        DATASOURCE_MAP,
        ZENODO_COMMUNITY_MAP;

    }
}

