/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NodeList;

public class OafToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    public static String oafResult(String resultId, boolean invisible, String provenance, String trust, NodeList about, String originalId, String dateOfCollection, String dateOfTransformation, NodeList metadata) {
        ValueMap values = null;
        try {
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            values = ValueMap.parseNodeList(metadata);
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            List<FieldTypeProtos.KeyValue> collectedFrom = OafToHbaseXsltFunctions.getKeyValues(values, "collectedfrom", TypeProtos.Type.datasource);
            List<FieldTypeProtos.KeyValue> hostedBy = OafToHbaseXsltFunctions.getKeyValues(values, "hostedby", TypeProtos.Type.datasource);
            ResultProtos.Result.Metadata.Builder metadataBuilder = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            ResultProtos.Result.Builder result = OafToHbaseXsltFunctions.buildResult(metadataBuilder, values, collectedFrom, hostedBy);
            OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, metadata, collectedFrom, originalId);
            entity.setDateofcollection(dateOfCollection).setDateoftransformation(dateOfTransformation).setOaiprovenance(OafToHbaseXsltFunctions.getOAIProvenance(about));
            OafProtos.Oaf oaf = OafToHbaseXsltFunctions.getOaf(entity, OafToHbaseXsltFunctions.getDataInfo(invisible, about, provenance, trust, false, false));
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, values);
            return null;
        }
    }

    public static String oafResultUpdate(String resultId, String provenance, String trust, NodeList nodelist) {
        ValueMap values = null;
        try {
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            values = ValueMap.parseNodeList(nodelist);
            List<FieldTypeProtos.KeyValue> hostedBy = OafToHbaseXsltFunctions.getKeyValues(values, "hostedby", TypeProtos.Type.datasource);
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            ResultProtos.Result.Metadata.Builder metadata = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            ResultProtos.Result.Builder result = OafToHbaseXsltFunctions.buildResult(metadata, values, null, hostedBy);
            OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, nodelist, null, null);
            OafProtos.Oaf oaf = OafToHbaseXsltFunctions.getOaf(entity, null);
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, values);
            return null;
        }
    }

    private static OafProtos.OafEntity.Builder buildOafEntity(ResultProtos.Result.Builder result, String entityId, NodeList nodelist, List<FieldTypeProtos.KeyValue> collectedFrom, String originalId) {
        ArrayList pids = Lists.newArrayList();
        pids.addAll(OafToHbaseXsltFunctions.parsePids(nodelist));
        OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, entityId, collectedFrom, StringUtils.isBlank((CharSequence)originalId) ? null : Lists.newArrayList((Object[])new String[]{originalId}), null, null, pids).setResult(result);
        return entity;
    }

    private static ResultProtos.Result.Metadata.Builder buildMetadata(ValueMap values, Descriptors.Descriptor mDesc) {
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        if (values.get("creator") != null) {
            for (Element e : values.get("creator")) {
                Person p;
                FieldTypeProtos.Author.Builder author = FieldTypeProtos.Author.newBuilder();
                String fullname = e.getText();
                author.setFullname(fullname);
                author.setRank(Integer.valueOf(e.getAttributeValue(ValueMap.IDX_ATTRIBUTE)).intValue());
                String nameIdentifier = e.getAttributeValue("nameIdentifier");
                String nameIdentifierScheme = e.getAttributeValue("nameIdentifierScheme");
                if (StringUtils.isNotBlank((CharSequence)nameIdentifier) && StringUtils.isNotBlank((CharSequence)nameIdentifierScheme)) {
                    author.addPid(OafToHbaseXsltFunctions.getKV(nameIdentifierScheme, nameIdentifier));
                }
                if ((p = new Person(fullname, false)).isAccurate()) {
                    author.setName(p.getNormalisedFirstName());
                    author.setSurname(p.getNormalisedSurname());
                }
                metadata.addAuthor(author);
            }
        }
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("subject"), values.get("subject"), "keyword", "dnet:subject_classification_typologies");
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("title"), values.get("title"), "main title", "dnet:dataCite_title");
        for (String fieldname : Lists.newArrayList((Object[])new String[]{"description", "source", "contributor"})) {
            if (values.get(fieldname) == null) continue;
            for (String s : values.get(fieldname).listValues()) {
                OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName(fieldname), s);
            }
        }
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("language"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), values.get("language").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());
        String resulttype = OafToHbaseXsltFunctions.getResultType(values);
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("resulttype"), OafToHbaseXsltFunctions.getSimpleQualifier(resulttype, "dnet:result_typologies"));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("format"), values.get("format").listValues());
        if (values.get("concept") != null) {
            for (Element e : values.get("concept")) {
                String id = e.getAttributes().get("id");
                if (StringUtils.isBlank((CharSequence)id)) {
                    throw new IllegalArgumentException("Context id cannot be blank");
                }
                metadata.addContext(ResultProtos.Result.Context.newBuilder().setId(id));
            }
        }
        if (values.get("journal") != null) {
            for (Element e : values.get("journal")) {
                Map<String, String> attr;
                ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder();
                if (e.getText() != null) {
                    journal.setName(e.getText());
                }
                if ((attr = e.getAttributes()) != null) {
                    if (attr.get("issn") != null) {
                        journal.setIssnPrinted(attr.get("issn"));
                    }
                    if (attr.get("eissn") != null) {
                        journal.setIssnOnline(attr.get("eissn"));
                    }
                    if (attr.get("lissn") != null) {
                        journal.setIssnLinking(attr.get("lissn"));
                    }
                    if (attr.get("ep") != null) {
                        journal.setEp(attr.get("ep"));
                    }
                    if (attr.get("iss") != null) {
                        journal.setIss(attr.get("iss"));
                    }
                    if (attr.get("sp") != null) {
                        journal.setSp(attr.get("sp"));
                    }
                    if (attr.get("vol") != null) {
                        journal.setVol(attr.get("vol"));
                    }
                }
                metadata.setJournal(journal.build());
            }
        }
        return metadata;
    }

    private static String getResultType(ValueMap values) {
        Element cobjcategory = values.get("cobjcategory").stream().map(e -> StringUtils.isNotBlank((CharSequence)e.getText()) ? e : new Element("0000", e.getAttributes())).findFirst().orElse(new Element("0000", new HashMap<String, String>()));
        String resulttype = cobjcategory.getAttributeValue("type");
        if (StringUtils.isNotBlank((CharSequence)resulttype)) {
            return resulttype;
        }
        return OafToHbaseXsltFunctions.getDefaultResulttype(cobjcategory);
    }

    private static ResultProtos.Result.Builder buildResult(ResultProtos.Result.Metadata.Builder metadata, ValueMap values, List<FieldTypeProtos.KeyValue> collectedFrom, List<FieldTypeProtos.KeyValue> hostedBy) {
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("license"), values.get("license").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("accessright"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("hostedby"), hostedBy);
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("collectedfrom"), collectedFrom);
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
        if (values.get("identifier") != null) {
            OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), Lists.newArrayList((Iterable)Iterables.filter(values.get("identifier").listValues(), (Predicate)urlFilter)));
        }
        result.addInstance(instance);
        ElementList extrefs = values.get("reference");
        if (!extrefs.isEmpty()) {
            Descriptors.Descriptor extDesc = ResultProtos.Result.ExternalReference.getDescriptor();
            for (Element element : extrefs) {
                ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("url"), element.getText());
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("query"), element.getAttributes().get("query"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("qualifier"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:externalReference_typologies"), Lists.newArrayList((Object[])new String[]{element.getAttributes().get("type")})).build());
                result.addExternalReference(extref);
            }
        }
        return result.setMetadata(metadata);
    }

    private static void handleException(Throwable e, String resultId, ValueMap values) {
        System.err.println("resultId: " + resultId);
        if (values != null) {
            System.err.println("values: " + values);
        }
        e.printStackTrace();
        throw new RuntimeException(e);
    }
}

