package eu.dnetlib.data.transform.xml2;

import java.util.Map;

import com.google.common.collect.Maps;

import static eu.dnetlib.data.transform.xml2.Utils.*;
import static eu.dnetlib.data.transform.xml2.VtdUtilityParser.xpath;

public class PublicationToProto extends AbstractResultDom4jParser {

    public PublicationToProto() {
        super(getFields());
    }

    public PublicationToProto(final boolean invisible, final String provenance, final String trust) {
        super(invisible, provenance, trust, getFields());
    }

    @Override
    protected String getResulttype(final String cobjcategory) {
        switch (cobjcategory) {
        case "0029":
            return "software";
        default:
            return "publication";
        }
    }

    protected static Map<String, String> getFields() {
        final Map<String, String> fields = Maps.newHashMap();

        fields.put("originalId", xpath("record", "header", "recordIdentifier"));
        fields.put("dateofcollection", xpath("record", "header", "dateOfCollection"));
        fields.put("dateoftransformation", xpath("record", "header", "dateOfTransformation"));
        fields.put("collectedfrom", metadataXpath("collectedFrom"));
        fields.put("pid", metadataXpath("identifier"));
        fields.put("license", metadataXpath("license"));
        fields.put("accessright", metadataXpath("accessrights"));
        fields.put("instancetype", metadataXpath("CobjCategory"));
        fields.put("hostedby", metadataXpath("hostedBy"));
        fields.put("url", metadataXpath("identifier"));
        fields.put("title", metadataXpath("title"));
        fields.put("description", metadataXpath("description"));
        fields.put("dateofacceptance", metadataXpath("dateAccepted"));
        fields.put("embargoenddate", metadataXpath("embargoenddate"));
        fields.put("storagedate", metadataXpath("storagedate"));
        fields.put("author", metadataXpath("creator"));
        fields.put("contributor", metadataXpath("contributor"));
        fields.put("subject", metadataXpath("subject"));
        fields.put("format", metadataXpath("format"));
        fields.put("source", metadataXpath("source"));
        fields.put("publisher", metadataXpath("publisher"));
        fields.put("language", metadataXpath("language"));
        fields.put("resulttype", metadataXpath("CobjCategory"));
        fields.put("concept", metadataXpath("concept"));
        fields.put("externalReference", metadataXpath("reference"));

        fields.put("cachedRel", String.format("%s | %s | %s",
                metadataXpath("projectid"),
                metadataXpath("relatedDataSet"),
                xpath("record", "metadata") + "//*[local-name()='relatedIdentifier']"));

        return fields;
    }

}
